/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.data.ClusterMetadataInitializer;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.kafka.DynamicClusterManager;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DynamicClusterMetadataInitializer
implements ClusterMetadataInitializer {
    private static final Logger log = LoggerFactory.getLogger(DynamicClusterMetadataInitializer.class);
    private static final long REFRESH_INTERVAL_MS = TimeUnit.MINUTES.toMillis(1L);
    private final String bootstrapClusterId;
    private final DynamicClusterManager clusterManager;
    private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("cluster-registry-refresh").setDaemon(true).build());

    @Inject
    public DynamicClusterMetadataInitializer(@HealthCheckModule.BootstrapClusterId String bootstrapClusterId, DynamicClusterManager clusterManager) {
        this.bootstrapClusterId = bootstrapClusterId;
        this.clusterManager = clusterManager;
    }

    @Override
    public ListenableFuture<Void> call() throws Exception {
        ListenableFuture<Void> future = this.clusterManager.initialize();
        future.addListener(() -> this.exec.schedule(this, REFRESH_INTERVAL_MS, TimeUnit.MILLISECONDS), (Executor)this.exec);
        return future;
    }

    @Override
    public String getBootstrapClusterId() {
        return this.bootstrapClusterId;
    }
}

