/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.confluent.controlcenter.ReferenceCountingHolder;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.kafka.ClusterChangeEvent;
import io.confluent.controlcenter.rest.ClusterMatched;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.Util;
import io.confluent.controlcenter.util.ProxyUtil;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingAdminSupplier<K extends ClusterMatched>
implements AdminSupplier<K> {
    private static final Logger log = LoggerFactory.getLogger(CachingAdminSupplier.class);
    private static final int DEFAULT_MAX_CACHE_SIZE = 10000;
    private static final long DEFAULT_CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(15L);
    private static final long CLEANUP_INTERVAL_MS = TimeUnit.SECONDS.toMillis(15L);
    private final LoadingCache<K, ReferenceCountingHolder<Admin>> cache;
    private final ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("client-cache-cleanup").setDaemon(true).build());

    public CachingAdminSupplier(AdminSupplier<K> baseSupplier) {
        this((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(DEFAULT_CACHE_EXPIRATION_MS, TimeUnit.MILLISECONDS), baseSupplier);
    }

    public CachingAdminSupplier(CacheBuilder<Object, Object> cacheBuilder, final AdminSupplier<K> baseSupplier) {
        this.cache = cacheBuilder.removalListener(notification -> ((ReferenceCountingHolder)notification.getValue()).close()).build(new CacheLoader<K, ReferenceCountingHolder<Admin>>(){

            public ReferenceCountingHolder<Admin> load(K key) {
                return new ReferenceCountingHolder<Admin>(baseSupplier.getClient(key));
            }
        });
        this.exec.scheduleAtFixedRate(this::cleanUp, CLEANUP_INTERVAL_MS, CLEANUP_INTERVAL_MS, TimeUnit.MILLISECONDS);
    }

    private void cleanUp() {
        log.debug("starting cleanup for expired tokens");
        List<TokenCredential> expiredTokens = Util.getExpiredTokens(this.cache.asMap().keySet());
        for (TokenCredential t : expiredTokens) {
            try {
                log.debug("closing expired AdminClient for token {}", (Object)t.token);
                ((ReferenceCountingHolder)this.cache.get((Object)t)).forceClose();
            }
            catch (ExecutionException e) {
                log.error("Error closing expired AdminClient", (Throwable)e);
            }
        }
        this.cache.invalidateAll(expiredTokens);
        if (!expiredTokens.isEmpty()) {
            log.debug("Invalidated expired AdminClient(s)");
        }
        log.debug("cleanup ended " + expiredTokens.toString());
        this.cache.cleanUp();
    }

    @Override
    public Admin getClient(K key) {
        try {
            ReferenceCountingHolder holder = (ReferenceCountingHolder)this.cache.get(key);
            log.debug("increment called for key {} count {}", key, (Object)holder.getReferenceCount());
            holder.increment();
            AtomicBoolean closed = new AtomicBoolean(false);
            Admin delegate = (Admin)holder.get();
            Runnable closeAction = () -> {
                if (closed.compareAndSet(false, true)) {
                    log.debug("decrement called for key {} count {}", key, (Object)holder.getReferenceCount());
                    holder.decrement();
                }
            };
            if (delegate instanceof ConfluentAdmin) {
                return (Admin)ProxyUtil.newDelegatingProxy(ConfluentAdmin.class, (ConfluentAdmin)delegate, closeAction);
            }
            return ProxyUtil.newDelegatingProxy(Admin.class, delegate, closeAction);
        }
        catch (UncheckedExecutionException uee) {
            Throwables.throwIfUnchecked((Throwable)uee.getCause());
            throw new RuntimeException(uee);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee.getCause());
        }
    }

    public void invalidate(K key) {
        this.cache.invalidate(key);
    }

    public void invalidateCluster(String clusterId) {
        this.cache.asMap().keySet().forEach(key -> {
            if (key.matchesCluster(clusterId)) {
                this.cache.invalidate(key);
            }
        });
    }

    @Subscribe
    public void handleClusterChangeEvent(ClusterChangeEvent clusterChangeEvent) {
        this.invalidateCluster(clusterChangeEvent.getClusterId());
    }
}

