/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterRegistryConfig;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.client.MetadataServiceClient;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ClusterMetadataInitializer;
import io.confluent.controlcenter.data.ClusterMetadataInitializerProxy;
import io.confluent.controlcenter.data.DynamicClusterMetadataDao;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.data.NoopPermissionsService;
import io.confluent.controlcenter.data.NoopServiceVisibilityFilter;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.data.RbacPermissionsService;
import io.confluent.controlcenter.data.RbacServiceVisibilityFilter;
import io.confluent.controlcenter.data.ServiceVisibilityFilter;
import io.confluent.controlcenter.data.StaticClusterMetadataDao;
import io.confluent.controlcenter.kafka.AdminClientFactory;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.kafka.CachingAdminSupplier;
import io.confluent.controlcenter.kafka.CachingConsumerSupplier;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.ClusterManagerProxy;
import io.confluent.controlcenter.kafka.ConsumerManager;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.kafka.DefaultAdminClientFactory;
import io.confluent.controlcenter.kafka.KafkaClusterAdminSupplier;
import io.confluent.controlcenter.kafka.KafkaRestManager;
import io.confluent.controlcenter.kafka.ProducerManager;
import io.confluent.controlcenter.kafka.ProducerSupplier;
import io.confluent.controlcenter.rest.KafkaRestApplications;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.rbacapi.jackson.MdsJacksonModule;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class ClusterManagementModule
extends AbstractModule {
    protected void configure() {
        this.bind(AdminClientFactory.class).to(DefaultAdminClientFactory.class).in(Singleton.class);
        this.bind(ClusterManager.class).to(ClusterManagerProxy.class).in(Singleton.class);
        this.bind(ClusterMetadataInitializer.class).to(ClusterMetadataInitializerProxy.class).in(Singleton.class);
    }

    @Provides
    @ControlCenterStarted
    @Singleton
    public AtomicBoolean provideControlCenterStarted() {
        return new AtomicBoolean();
    }

    @Provides
    @Inject
    @ClusterChangeEventBus
    @Singleton
    public EventBus provideClusterChangeEventBus(ClusterMetadataDao clusterMetadataDao, KafkaRestManager kafkaRestManager, CachingConsumerSupplier<byte[], byte[]> cachingConsumerSupplier, AdminSupplier<TokenCredential> adminClientSupplier, KafkaRestApplications restApplications) {
        EventBus clusterChangeEventBus = new EventBus("cluster-change-event-bus");
        clusterChangeEventBus.register((Object)clusterMetadataDao);
        clusterChangeEventBus.register((Object)kafkaRestManager);
        clusterChangeEventBus.register(cachingConsumerSupplier);
        clusterChangeEventBus.register(adminClientSupplier);
        clusterChangeEventBus.register((Object)restApplications);
        return clusterChangeEventBus;
    }

    @Provides
    @Singleton
    @Inject
    ClusterMetadataDao clusterMetadataDao(Injector injector, ClusterRegistryConfig config) {
        if (config.isClusterRegistryEnabled()) {
            return (ClusterMetadataDao)injector.getInstance(DynamicClusterMetadataDao.class);
        }
        return (ClusterMetadataDao)injector.getInstance(StaticClusterMetadataDao.class);
    }

    @Provides
    @Singleton
    @Inject
    AdminSupplier<TokenCredential> adminClientSupplier(KafkaClusterAdminSupplier kafkaClusterAdminSupplier) {
        return new CachingAdminSupplier<TokenCredential>(kafkaClusterAdminSupplier);
    }

    @Provides
    @Singleton
    @Inject
    AdminSupplier<String> adminClientSupplier(final AdminSupplier<TokenCredential> adminClientSupplier) {
        return new AdminSupplier<String>(){

            @Override
            public Admin getClient(String clusterId) {
                return adminClientSupplier.getClient(TokenCredential.makeCredential(clusterId));
            }
        };
    }

    @Provides
    @Singleton
    @Inject
    ConsumerSupplier<byte[], byte[]> consumerSupplier(ClusterManager clusterManager) {
        ImmutableMap configs = ImmutableMap.builder().put((Object)"enable.auto.commit", (Object)false).put((Object)"max.poll.records", (Object)10).put((Object)"key.deserializer", ByteArrayDeserializer.class).put((Object)"value.deserializer", ByteArrayDeserializer.class).build();
        return new ConsumerManager<byte[], byte[]>(clusterManager, (Map<String, Object>)configs);
    }

    @Provides
    @Singleton
    @Inject
    ProducerSupplier<byte[], byte[]> producerSupplier(ClusterManager clusterManager) {
        ImmutableMap configs = ImmutableMap.builder().put((Object)"client.id", (Object)"").put((Object)"key.serializer", ByteArraySerializer.class).put((Object)"value.serializer", ByteArraySerializer.class).put((Object)"linger.ms", (Object)100).put((Object)"batch.size", (Object)1024).build();
        return new ProducerManager<byte[], byte[]>(clusterManager, (Map<String, Object>)configs);
    }

    @Provides
    @Singleton
    @Inject
    @LastProduceTimeConsumerSupplier
    ConsumerSupplier<byte[], byte[]> lastProduceTimeConsumerSupplier(ClusterManager clusterManager) {
        return new ConsumerManager<byte[], byte[]>(clusterManager, (Map<String, Object>)ImmutableMap.builder().put((Object)"max.poll.records", (Object)Integer.MAX_VALUE).put((Object)"key.deserializer", ByteArrayDeserializer.class).put((Object)"value.deserializer", ByteArrayDeserializer.class).put((Object)"isolation.level", (Object)"read_committed").put((Object)"enable.auto.commit", (Object)false).build());
    }

    @Provides
    @Singleton
    ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new MdsJacksonModule());
        return objectMapper;
    }

    @Provides
    @Singleton
    @Inject
    MetadataServiceClient metadataServiceClient(ControlCenterConfig controlCenterConfig, ControlCenterRbacConfig rbacConfig, ObjectMapper objectMapper, @ServiceHealthCheckModule.MetadataServiceHealthCheck SingleServiceHealthCheck mdsHealthCheck) {
        if (rbacConfig.isRbacEnabled()) {
            return new MetadataServiceClient(controlCenterConfig, rbacConfig, objectMapper, mdsHealthCheck);
        }
        return null;
    }

    @Provides
    @Singleton
    @Inject
    ServiceVisibilityFilter serviceVisibilityFilter(ControlCenterConfig controlCenterConfig, ControlCenterRbacConfig rbacConfig, ObjectMapper objectMapper, PermissionsService permissionsService) {
        if (rbacConfig.isRbacEnabled()) {
            return new RbacServiceVisibilityFilter(controlCenterConfig, objectMapper, permissionsService);
        }
        return new NoopServiceVisibilityFilter();
    }

    @Provides
    @Singleton
    @Inject
    PermissionsService permissionsService(ControlCenterRbacConfig rbacConfig, ClusterMetadataDao clusterMetadataDao, KafkaMetadataDao kafkaMetadataDao, @Nullable MetadataServiceClient mdsClient) {
        if (rbacConfig.isRbacEnabled()) {
            return new RbacPermissionsService(clusterMetadataDao, kafkaMetadataDao, mdsClient);
        }
        return new NoopPermissionsService(clusterMetadataDao);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface LastProduceTimeConsumerSupplier {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlCenterStarted {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ClusterChangeEventBus {
    }
}

