/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterRegistryConfig;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.DynamicClusterManager;
import io.confluent.controlcenter.kafka.StaticClusterManager;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.Map;

@Singleton
public class ClusterManagerProxy
implements ClusterManager {
    private final StaticClusterManager staticClusterManager;
    private final DynamicClusterManager dynamicClusterManager;
    private final ClusterRegistryConfig registryConfig;
    private final ControlCenterRbacConfig rbacConfig;
    private final ControlCenterConfig config;

    @Inject
    public ClusterManagerProxy(StaticClusterManager staticClusterManager, DynamicClusterManager dynamicClusterManager, ClusterRegistryConfig registryConfig, ControlCenterRbacConfig rbacConfig, ControlCenterConfig config) {
        this.staticClusterManager = staticClusterManager;
        this.dynamicClusterManager = dynamicClusterManager;
        this.registryConfig = registryConfig;
        this.rbacConfig = rbacConfig;
        this.config = config;
    }

    @Override
    public Map<String, Object> getConfiguration(TokenCredential credential) {
        Map<String, Map<String, Object>> configurations = this.getConfigurations();
        Map clusterConfigs = (Map)Preconditions.checkNotNull(configurations.get(credential.cluster), (String)"Unknown configuration for cluster id %s", (Object)credential.cluster);
        return this.rbacConfig.injectRbacConfigs(clusterConfigs, credential.token);
    }

    @Override
    public Map<String, Map<String, Object>> getConfigurations() {
        Map<String, Map<String, Object>> staticConfigs = this.staticClusterManager.getConfigurations();
        if (this.registryConfig.isClusterRegistryEnabled()) {
            Map<String, Map<String, Object>> dynamicConfigs = this.dynamicClusterManager.getConfigurations();
            if (this.config.getBoolean("confluent.metadata.cluster.registry.merge.configuration.enable").booleanValue()) {
                return ConfigUtils.merge(staticConfigs, dynamicConfigs);
            }
            return dynamicConfigs;
        }
        return staticConfigs;
    }
}

