/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.kafka.AdminClientFactory;
import io.confluent.controlcenter.kafka.ClusterChangeEvent;
import io.confluent.controlcenter.kafka.ClusterManagementModule;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.util.RetryUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StaticClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(StaticClusterManager.class);
    private static final int CONFIG_RETRY_BACKOFF = 1000;
    private final ConcurrentMap<String, Map<String, Object>> configurations = new ConcurrentHashMap<String, Map<String, Object>>();
    private final ConcurrentSkipListSet<String> clusterNames = new ConcurrentSkipListSet();
    private final AdminClientFactory clientFactory;
    private final Provider<EventBus> eventBusProvider;
    private final ControlCenterRbacConfig rbacConfig;

    @Inject
    public StaticClusterManager(@ClusterManagementModule.ClusterChangeEventBus Provider<EventBus> eventBusProvider, AdminClientFactory clientFactory, ControlCenterRbacConfig rbacConfig) {
        this.eventBusProvider = eventBusProvider;
        this.clientFactory = clientFactory;
        this.rbacConfig = rbacConfig;
    }

    @Override
    public Map<String, Object> getConfiguration(TokenCredential credential) {
        Map clusterConfigs = (Map)Preconditions.checkNotNull(this.configurations.get(credential.cluster), (String)"Unknown configuration for cluster id %s", (Object)credential.cluster);
        return this.rbacConfig.injectRbacConfigs(clusterConfigs, credential.token);
    }

    @Override
    public Map<String, Map<String, Object>> getConfigurations() {
        return this.configurations;
    }

    @VisibleForTesting
    public ListenableFuture<String> register(String clusterName, Map<String, Object> config) {
        Preconditions.checkNotNull((Object)clusterName, (Object)"Cluster name must not be null");
        Preconditions.checkNotNull(config, (Object)"Configuration must not be null");
        Preconditions.checkArgument((boolean)this.clusterNames.add(clusterName), (String)"Cluster configuration %s already exists", (Object)clusterName);
        HashMap<String, Object> mutableConfig = new HashMap<String, Object>(config);
        if (this.rbacConfig.isRbacEnabled()) {
            if (!this.configUsesOauthBearerOrDefault(mutableConfig)) {
                throw new ConfigException("When RBAC is enabled, you must use the OAUTHBEARER SASL mechanism.");
            }
            mutableConfig.putIfAbsent("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        }
        Map<String, Object> finalConfig = this.rbacConfig.injectRbacConfigs(mutableConfig);
        return RetryUtils.retryWithJitter(() -> {
            SettableFuture lookup = SettableFuture.create();
            this.lookupClusterId(finalConfig).whenComplete((clusterId, throwable) -> {
                if (throwable == null) {
                    this.postLookupClusterId(clusterName, (String)clusterId, mutableConfig);
                    lookup.set(clusterId);
                } else {
                    lookup.setException(throwable);
                }
            });
            return lookup;
        }, 1000);
    }

    @VisibleForTesting
    public KafkaFuture<String> lookupClusterId(Map<String, Object> config) {
        try (AdminClient admin = this.clientFactory.createClient(config);){
            KafkaFuture kafkaFuture = admin.describeCluster().clusterId();
            return kafkaFuture;
        }
    }

    private void postLookupClusterId(String clusterName, String clusterId, Map<String, Object> config) {
        try {
            this.configurations.put(clusterId, config);
            ((EventBus)this.eventBusProvider.get()).post((Object)new ClusterChangeEvent(clusterName, clusterId, config, (EventBus)this.eventBusProvider.get()));
            this.clusterNames.remove(clusterName);
        }
        catch (Throwable ex) {
            log.warn("Failure during post-processing of cluster id", ex);
        }
    }

    private boolean configUsesOauthBearerOrDefault(Map<String, Object> config) {
        Object securityProtocol = config.get("security.protocol");
        Object saslMechanism = config.get("sasl.mechanism");
        if (securityProtocol != null && !securityProtocol.equals(SecurityProtocol.SASL_PLAINTEXT.name) && !securityProtocol.equals(SecurityProtocol.SASL_SSL.name)) {
            return false;
        }
        return saslMechanism == null || saslMechanism.equals("OAUTHBEARER");
    }
}

