/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import com.google.common.collect.ImmutableMap;
import io.confluent.controlcenter.license.LicenseSelectionStrategy;
import io.confluent.controlcenter.license.LicenseUtils;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseChanged;
import io.confluent.license.LicenseManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseHolder
implements Consumer<LicenseChanged> {
    private static final Logger log = LoggerFactory.getLogger(LicenseHolder.class);
    static final String ID = "id";
    static final String TYPE = "type";
    static final String COLLECTION = "collection";
    static final String ENCODING = "encoding";
    static final String COLLECTION_VAL = "accounts";
    static final String ENCODING_VAL = "none";
    private List<License> licenses;
    private License currentLicense;
    private final LicenseManager licenseManager;

    public LicenseHolder(List<License> activeLicenses, LicenseManager licenseManager) {
        this.licenses = Objects.requireNonNull(activeLicenses, "activeLicenses cannot be null");
        this.licenseManager = Objects.requireNonNull(licenseManager, "licenseManager cannot be null");
        this.currentLicense = LicenseSelectionStrategy.selectLicenseBasedOnLargerExpiry(this.licenses);
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public License getCurrentLicense() {
        return this.currentLicense;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    @Override
    public void accept(LicenseChanged licenseChanged) {
        if (licenseChanged.type().equals((Object)LicenseChanged.Type.INVALID)) {
            log.warn("License supplied is invalid");
            return;
        }
        this.logLicenseChange(licenseChanged);
        this.updateLicenses(licenseChanged);
    }

    private void updateLicenses(LicenseChanged licenseChanged) {
        this.licenses = licenseChanged.existingLicenses();
        if (this.licenses != null && !this.licenses.isEmpty()) {
            this.currentLicense = LicenseSelectionStrategy.selectLicenseBasedOnLargerExpiry(this.licenses);
            LicenseUtils.printCP4CCInfoLog(this.licenses);
        }
    }

    private void logLicenseChange(LicenseChanged licenseChanged) {
        switch (licenseChanged.type()) {
            case EXPIRED: {
                log.error("License expired.");
                break;
            }
            case RENEWAL: {
                log.info("License renewed - expiration date extended.");
                break;
            }
            case UPDATED: {
                License newCurrentLicense = LicenseSelectionStrategy.selectLicenseBasedOnLargerExpiry(this.licenses);
                if (!this.currentLicense.deploymentScope().equals((Object)newCurrentLicense.deploymentScope())) {
                    String newLicenseCategory = this.determineLicenseCategory(newCurrentLicense);
                    log.info("License switched to a new license category: {}", (Object)newLicenseCategory);
                    break;
                }
                log.info("License updated - more changes than just expiration date.");
                break;
            }
            default: {
                log.info("License change detected: {}", (Object)licenseChanged.type());
            }
        }
    }

    private Map<String, Object> getTrackingId() {
        if (this.currentLicense == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"audience", (Object)this.currentLicense.audienceString(), (Object)"lid", (Object)this.currentLicense.licenseId(), (Object)"pid", (Object)this.currentLicense.platformId());
    }

    public List<Map<String, Object>> getExternalId() {
        Map<String, Object> trackingId = this.getTrackingId();
        return trackingId.entrySet().stream().map(entry -> ImmutableMap.of((Object)ID, entry.getValue(), (Object)TYPE, entry.getKey(), (Object)COLLECTION, (Object)COLLECTION_VAL, (Object)ENCODING, (Object)ENCODING_VAL)).collect(Collectors.toList());
    }

    public String determineLicenseCategory(License license) {
        if (license.deploymentScope().equals((Object)License.DeploymentScope.CP_FOR_CC)) {
            return "Customer-Managed Confluent Platform for Confluent Cloud";
        }
        if (license.deploymentScope().equals((Object)License.DeploymentScope.CP)) {
            return "Confluent Platform";
        }
        throw new InvalidLicenseException("Unsupported license deployment scope: " + license.deploymentScope());
    }
}

