/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import com.google.common.base.Strings;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.List;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseReader {
    private static final Logger log = LoggerFactory.getLogger(LicenseReader.class);

    private LicenseReader() {
    }

    public static List<License> readAndRegisterLicenses(String licenseStr, LicenseManager licenseMgr) throws Exception {
        boolean isJwtToken;
        try {
            License.verify((PublicKey)LicenseManager.loadPublicKey(), (String)licenseStr);
            isJwtToken = true;
        }
        catch (InvalidJwtException e) {
            isJwtToken = false;
        }
        if (!isJwtToken) {
            licenseStr = LicenseReader.readLicenseStringFromFile(licenseStr);
        }
        try {
            return LicenseReader.readAndRegisterFromString(licenseStr, licenseMgr);
        }
        catch (InvalidLicenseException ine) {
            log.error("license={} is invalid {}. please contact support@confluent.io for a valid license key", (Object)licenseStr, (Object)"InvalidLicenseException");
            throw ine;
        }
    }

    public static List<License> readAndRegisterFromString(String licenseStr, LicenseManager licenseMgr) throws InvalidLicenseException {
        List licenses;
        try {
            licenses = licenseMgr.registerOrValidateMultiLicense(licenseStr, true);
            if (licenses.isEmpty()) {
                throw new InvalidLicenseException("No valid license found.");
            }
        }
        catch (InvalidLicenseException e) {
            licenses = licenseMgr.registerOrValidateMultiLicense(licenseStr, false);
        }
        return licenses;
    }

    private static String readLicenseStringFromFile(String licensePathStr) throws Exception {
        String licenseStr = "";
        try {
            Path licensePath = Paths.get(licensePathStr, new String[0]);
            if (licensePath.toFile().exists() && licensePath.toFile().isFile()) {
                log.info("attempting to read license from path={}", (Object)licensePath);
                licenseStr = Strings.nullToEmpty((String)Files.newBufferedReader(licensePath, Charset.defaultCharset()).readLine()).trim();
            } else {
                log.info("{} is neither a valid license string nor a valid license path. ", (Object)licensePathStr);
            }
        }
        catch (InvalidPathException ipe) {
            log.error("Catch InvalidPathException when parsing license file path.", (Throwable)ipe);
            throw ipe;
        }
        catch (IOException ioe) {
            log.error("Catch IOException when parsing license file path.", (Throwable)ioe);
            throw ioe;
        }
        catch (Exception exp) {
            log.error("Catch Exception when parsing license file path.", (Throwable)exp);
            throw exp;
        }
        return licenseStr;
    }
}

