/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import io.confluent.license.License;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtils {
    private static final Logger log = LoggerFactory.getLogger(LicenseUtils.class);

    private LicenseUtils() {
    }

    static void printCP4CCInfoLog(List<License> licenses) {
        boolean hasCP4CCLicense = licenses.stream().filter(Objects::nonNull).anyMatch(license -> license.deploymentScope().equals((Object)License.DeploymentScope.CP_FOR_CC));
        if (hasCP4CCLicense) {
            log.info("\n***************************LICENSE NOTICE***************************\nYour license for Customer-Managed Confluent Platform for Confluent \nCloud may be used solely to access and use the Cloud Service. When  \noperating under this specific license, Confluent does not provide  \nsupport for any self-managed (Confluent Platform) components utilised  \nexclusively for Confluent Platform broker use cases. To be eligible  \nfor support, you must ensure you are connecting to a Confluent Cloud  \nbroker or are utilising a valid Enterprise license for a Confluent  \nPlatform subscription \n***************************END MESSAGE***************************");
        }
    }
}

