/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.consumption.ConsumerHelper;
import io.confluent.controlcenter.rest.CompoundClusterTokenCredential;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.rest.Util;
import io.confluent.controlcenter.rest.res.ConsumeToSocket;
import io.confluent.controlcenter.rest.res.OmgDeserializer;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.controlcenter.util.PrincipalUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumerResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractConsumerResource.class);
    private final ListeningScheduledExecutorService executorService;
    private final SchemaRegistryClientSupplier<CompoundClusterTokenCredential> schemaRegistryClientSupplier;
    private ListenableScheduledFuture<?> current;
    private static final String WEBSOCKET_TIMEOUT_ERROR_MSG = "Idle timeout expired";
    private Long maxMessageSize;

    @Inject
    public AbstractConsumerResource(@RestModule.WebSockets ListeningScheduledExecutorService executorService, @ControlCenterConfigModule.MaxTopicMessageSize Long maxMessageSize, SchemaRegistryClientSupplier<CompoundClusterTokenCredential> schemaRegistryClientSupplier) {
        this.executorService = executorService;
        this.schemaRegistryClientSupplier = schemaRegistryClientSupplier;
        this.maxMessageSize = maxMessageSize;
    }

    abstract Consumer<byte[], byte[]> getConsumer(String var1, Session var2);

    abstract OmgDeserializer getDeserializer(SchemaRegistryClient var1);

    private static String extract(Map<String, List<String>> params, String key) {
        String out = "";
        if (params.containsKey(key)) {
            out = (String)Iterables.getLast((Iterable)params.get(key), (Object)"");
        }
        return StringUtils.stripToEmpty((String)out);
    }

    private static long extractAsLong(Session session, Map<String, List<String>> params, String key, long defaultValue) throws IOException {
        long out;
        block3: {
            out = defaultValue;
            try {
                String stringValue = AbstractConsumerResource.extract(params, key);
                if (!StringUtils.isEmpty((CharSequence)stringValue)) {
                    out = Long.parseLong(stringValue);
                }
            }
            catch (NumberFormatException nfe) {
                log.warn("parsing " + key, (Throwable)nfe);
                if (!session.isOpen()) break block3;
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, out + " is invalid " + key));
            }
        }
        return out;
    }

    private SchemaRegistryClient getSchemaRegistryClient(String clusterId, Session session, String srClusterId) {
        CompoundClusterTokenCredential credential = CompoundClusterTokenCredential.makeCredentialFromJwtOrNullPrincipal(clusterId, srClusterId, session.getUserPrincipal());
        try {
            return this.schemaRegistryClientSupplier.getClient(credential);
        }
        catch (Exception e) {
            String err = String.format("Failed to provide a SchemaRegistryClient for kafka cluster '%s', schema registry cluster id '%s'.", clusterId, srClusterId);
            log.error(err, (Throwable)e);
            throw new RuntimeException(err);
        }
    }

    @OnOpen
    public void onSessionOpened(Session session, @PathParam(value="clusterId") String clusterId) throws IOException, ExecutionException, InterruptedException {
        Map parameters = session.getRequestParameterMap();
        this.maybeScheduleSessionTimeout(session);
        String fromBeginning = AbstractConsumerResource.extract(parameters, "fromBeginning");
        String offset = AbstractConsumerResource.extract(parameters, "offset");
        String timestamp = AbstractConsumerResource.extract(parameters, "timestamp");
        if (!this.atMostOne(fromBeginning, offset, timestamp)) {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "only one of fromBeginning, offset, timestamp may be set"));
        }
        ConsumerHelper.Position position = null;
        position = fromBeginning.toLowerCase().equals("true") ? new ConsumerHelper.Position(ConsumerHelper.Position.Type.EARLIEST, null) : (!StringUtils.isEmpty((CharSequence)offset) ? this.getPosition(session, ConsumerHelper.Position.Type.OFFSET, offset) : (!StringUtils.isEmpty((CharSequence)timestamp) ? this.getPosition(session, ConsumerHelper.Position.Type.TIMESTAMP, timestamp) : new ConsumerHelper.Position(ConsumerHelper.Position.Type.LATEST, null)));
        long limit = AbstractConsumerResource.extractAsLong(session, parameters, "limit", Long.MAX_VALUE);
        long partition = AbstractConsumerResource.extractAsLong(session, parameters, "partition", -1L);
        long consumerPollDelay = AbstractConsumerResource.extractAsLong(session, parameters, "consumerPollDelay", 1000L);
        if (!session.isOpen()) {
            return;
        }
        final Consumer<byte[], byte[]> consumer = this.getConsumer(clusterId, session);
        final String topic = AbstractConsumerResource.extract(parameters, "topic");
        log.info("trace getting tps");
        List assignment = Lists.transform(consumer.partitionsFor(topic).stream().filter(p -> partition == -1L || (long)p.partition() == partition).collect(Collectors.toList()), (Function)new Function<PartitionInfo, TopicPartition>(){

            public TopicPartition apply(PartitionInfo partitionInfo) {
                return new TopicPartition(topic, partitionInfo.partition());
            }
        });
        if (assignment.isEmpty()) {
            session.close();
            return;
        }
        log.info("assigning={}", (Object)assignment);
        consumer.assign((Collection)assignment);
        ConsumerHelper.setPosition(consumer, position);
        log.info("trace position set");
        String srClusterId = AbstractConsumerResource.extract(parameters, "srClusterId");
        log.info("schema registry id={}", (Object)srClusterId);
        this.current = this.executorService.scheduleWithFixedDelay((Runnable)new ConsumeToSocket(session, consumer, limit, this.maxMessageSize, this.getDeserializer(this.getSchemaRegistryClient(clusterId, session, srClusterId))), 0L, consumerPollDelay, TimeUnit.MILLISECONDS);
        this.current.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    log.trace("closing consumer");
                    consumer.close();
                }
                catch (Throwable t) {
                    log.warn("unable to close consumer", t);
                }
            }
        }, (Executor)this.executorService);
    }

    private void maybeScheduleSessionTimeout(Session session) {
        JwtPrincipal principal = PrincipalUtils.jwtPrincipalOrNull(session.getUserPrincipal());
        if (principal != null) {
            long tokenLifetimeMs = Util.getTokenLifetimeMs(principal.getJwt());
            this.executorService.schedule(() -> {
                try {
                    session.close();
                    log.info("Consumer session closed for principal={}", (Object)principal.getName());
                }
                catch (IOException e) {
                    log.warn("Could not force close websockets session", (Throwable)e);
                }
            }, tokenLifetimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private ConsumerHelper.Position getPosition(Session session, ConsumerHelper.Position.Type type, String pos) throws IOException {
        ConsumerHelper.Position position;
        try {
            position = new ConsumerHelper.Position(type, Long.parseLong(pos));
        }
        catch (NumberFormatException nfe) {
            log.warn("parsing timestamp", (Throwable)nfe);
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, pos + " is invalid " + (Object)((Object)type)));
            return null;
        }
        if (position.position() <= 0L && !type.equals((Object)ConsumerHelper.Position.Type.OFFSET)) {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, (Object)((Object)type) + " must be nonnegative"));
            return null;
        }
        return position;
    }

    private boolean atMostOne(String fromBeginning, String offset, String timestamp) {
        if (!StringUtils.isEmpty((CharSequence)fromBeginning)) {
            return StringUtils.isEmpty((CharSequence)offset) && StringUtils.isEmpty((CharSequence)timestamp);
        }
        if (!StringUtils.isEmpty((CharSequence)offset)) {
            return StringUtils.isEmpty((CharSequence)timestamp);
        }
        return true;
    }

    @OnMessage
    public void onMessageReceived(String message, Session session) {
        log.trace("got message={}", (Object)message);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        log.trace("closeReason={}", (Object)closeReason);
        if (this.current != null) {
            this.current.cancel(true);
        }
    }

    @OnError
    public void onErrorReceived(Throwable t) {
        if (t.getCause() instanceof TimeoutException && t.getMessage().contains(WEBSOCKET_TIMEOUT_ERROR_MSG)) {
            log.info("Websocket timed out as no new messages were received");
        } else {
            log.error("error", t);
        }
    }
}

