/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.errors.ProduceMessageException;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.rest.Util;
import io.confluent.controlcenter.util.PrincipalUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducerResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractProducerResource.class);
    protected String version;
    protected String topic;
    protected KafkaProducer<byte[], byte[]> producer;
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";
    public static final Set<String> PROPS = ImmutableSet.of((Object)"KEY", (Object)"VALUE");
    private static final String V2 = "2.0";
    private static final String V3 = "3.0";
    private static final byte[] NULL = "null".getBytes(StandardCharsets.UTF_8);
    private static final int MAX_MESSAGE_SIZE = 0x100000;
    private final ListeningScheduledExecutorService executorService;

    abstract KafkaProducer<byte[], byte[]> getProducer(String var1, Session var2);

    @Inject
    public AbstractProducerResource(@RestModule.WebSockets ListeningScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        log.trace("got message={}", (Object)message);
        if (this.producer == null) {
            throw new ProduceMessageException("no producer registered yet");
        }
        switch (this.version) {
            case "2.0": {
                this.onMessageV2(session, message);
                break;
            }
            case "3.0": {
                this.onMessageV3(session, message);
                break;
            }
            default: {
                throw new ProduceMessageException("faulty version specified");
            }
        }
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="clusterId") String clusterId, @PathParam(value="version") String version) {
        if (!version.equals(V2) && !version.equals(V3)) {
            throw new ProduceMessageException("faulty version specified");
        }
        this.version = version;
        session.setMaxBinaryMessageBufferSize(0x100000);
        session.setMaxTextMessageBufferSize(0x100000);
        Map parameters = session.getRequestParameterMap();
        this.topic = AbstractProducerResource.extract(parameters, "topic");
        this.producer = this.getProducer(clusterId, session);
        this.maybeScheduleSessionTimeout(session);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) throws IOException {
        log.trace("closeReason={}", (Object)closeReason);
        if (this.producer != null) {
            try {
                log.trace("closing producer");
                this.producer.flush();
                this.producer.close();
            }
            catch (Throwable t) {
                log.warn("unable to close producer", t);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) throws IOException, EncodeException {
        log.warn(throwable.getLocalizedMessage());
        session.getBasicRemote().sendObject((Object)Response.serverError().entity((Object)throwable.getLocalizedMessage()).build());
        if (throwable instanceof MessageTooLargeException) {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, throwable.getLocalizedMessage()));
        } else {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, throwable.getLocalizedMessage()));
        }
    }

    protected void onMessageV2(Session session, String message) {
        byte[] byteMessage = message.getBytes(StandardCharsets.UTF_8);
        this.produceMessage(session, null, byteMessage);
    }

    protected void onMessageV3(Session session, String message) {
        JsonObject obj;
        try {
            obj = JsonParser.parseString((String)message).getAsJsonObject();
        }
        catch (Exception ex) {
            throw new ProduceMessageException(ex, "failed to parse JSON message");
        }
        if (!obj.keySet().equals(PROPS)) {
            throw new ProduceMessageException("JSON message does not follow required schema");
        }
        this.produceMessage(session, AbstractProducerResource.getBytesFromJson(obj.get(KEY)), AbstractProducerResource.getBytesFromJson(obj.get(VALUE)));
    }

    private void produceMessage(Session session, byte[] byteKey, byte[] byteVal) {
        try {
            this.producer.send(new ProducerRecord(this.topic, (Object)byteKey, (Object)byteVal)).get(3000L, TimeUnit.MILLISECONDS);
            session.getBasicRemote().sendObject((Object)Response.ok().build());
        }
        catch (Exception ex) {
            throw new ProduceMessageException(ex, "Kafka internal produce error");
        }
    }

    private static byte[] getBytesFromJson(JsonElement e) {
        byte[] result = e.toString().getBytes(StandardCharsets.UTF_8);
        if (Arrays.equals(result, NULL)) {
            result = null;
        }
        return result;
    }

    private static String extract(Map<String, List<String>> params, String key) {
        String out = "";
        if (params.containsKey(key)) {
            out = (String)Iterables.getLast((Iterable)params.get(key), (Object)"");
        }
        return StringUtils.stripToEmpty((String)out);
    }

    private void maybeScheduleSessionTimeout(Session session) {
        JwtPrincipal principal = PrincipalUtils.jwtPrincipalOrNull(session.getUserPrincipal());
        if (principal != null) {
            long tokenLifetimeMs = Util.getTokenLifetimeMs(principal.getJwt());
            this.executorService.schedule(() -> {
                try {
                    session.close();
                    log.info("Consumer session closed for principal={}", (Object)principal.getName());
                }
                catch (IOException e) {
                    log.warn("Could not force close websockets session", (Throwable)e);
                }
            }, tokenLifetimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

