/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.security.Principal;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/3.0/auth")
@Produces(value={"application/json"})
public class AuthResource {
    private static final Logger log = LoggerFactory.getLogger(AuthResource.class);
    private final Collection<String> readOnlyRoles;

    @Inject
    public AuthResource(@ControlCenterRestModule.RestrictedRoles Collection<String> readOnlyRoles) {
        this.readOnlyRoles = readOnlyRoles;
    }

    @GET
    @Path(value="/principal")
    public Response principal(@Context SecurityContext securityContext) {
        Principal user = securityContext.getUserPrincipal();
        boolean readOnly = false;
        for (String role : this.readOnlyRoles) {
            boolean userInRole = securityContext.isUserInRole(role);
            log.debug("checking if user={} in role={} val={}", new Object[]{user, role, userInRole});
            readOnly |= userInRole;
        }
        CacheControl cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
        cc.setMustRevalidate(true);
        String userName = user == null ? null : user.getName();
        return Response.ok((Object)new PrincipalInfo(userName, readOnly)).cacheControl(cc).build();
    }

    @JsonStandard
    public static class PrincipalInfo {
        public final String user;
        public final boolean readOnly;

        PrincipalInfo(String user, boolean readOnly) {
            this.user = user;
            this.readOnly = readOnly;
        }
    }
}

