/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.data.ScopedKafkaMetadataDao;
import io.confluent.controlcenter.rest.VisibleCluster;
import io.confluent.controlcenter.rest.res.ConsumerGroup;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Path(value="/2.0/consumer/offsets/{clusterId}")
@Produces(value={"application/json"})
public class CachedConsumerOffsetsResource {
    private final Map<String, Map<String, ConsumerGroupOffsets>> offsets;
    @Context
    private ScopedKafkaMetadataDao scopedKafkaMetadataDao;

    @Inject
    public CachedConsumerOffsetsResource(@ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> offsets) {
        this.offsets = offsets;
    }

    @GET
    public List<ConsumerGroup> all(@PathParam(value="clusterId") VisibleCluster cluster, @DefaultValue(value="") @QueryParam(value="topicName") String topicName) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.filteredOffsets(cluster.getClusterId(), topicName);
        return cgOffsets.values().stream().map(ConsumerGroup::new).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{consumerGroupId}")
    public ConsumerGroupOffsets consumerGroup(@PathParam(value="clusterId") VisibleCluster cluster, @PathParam(value="consumerGroupId") String consumerGroupId, @DefaultValue(value="") @QueryParam(value="topicName") String topicName) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.filteredOffsets(cluster.getClusterId(), topicName);
        ConsumerGroupOffsets offsets = cgOffsets.get(consumerGroupId);
        if (offsets == null) {
            if (!topicName.isEmpty()) {
                throw new NotFoundException("unable to find consumerGroupId=" + consumerGroupId + " or consumerGroupId linked to topicName=" + topicName);
            }
            throw new NotFoundException("unable to find consumerGroupId=" + consumerGroupId);
        }
        return offsets;
    }

    private Map<String, ConsumerGroupOffsets> filteredOffsets(String clusterId, String topicName) throws InterruptedException, ExecutionException, TimeoutException {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.offsets.get(clusterId);
        if (cgOffsets == null) {
            throw new NotFoundException("unable to find clusterId=" + clusterId);
        }
        Set<String> filteredGroups = this.scopedKafkaMetadataDao.getConsumerGroups(clusterId);
        if (topicName.isEmpty()) {
            return cgOffsets.entrySet().stream().filter(entry -> filteredGroups.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return cgOffsets.entrySet().stream().filter(entry -> ((ConsumerGroupOffsets)entry.getValue()).consumerGroupOffsets.containsKey(topicName)).map(entry -> this.pruneByTopicName((Map.Entry<String, ConsumerGroupOffsets>)entry, topicName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map.Entry<String, ConsumerGroupOffsets> pruneByTopicName(Map.Entry<String, ConsumerGroupOffsets> entry, String topicName) {
        HashSet topicsToRemove = new HashSet();
        for (Map.Entry<String, ConsumerGroupOffsets.TopicOffsets> topic : entry.getValue().consumerGroupOffsets.entrySet()) {
            if (topic.getKey().equals(topicName)) continue;
            topicsToRemove.add(topic.getKey());
        }
        for (Map.Entry<String, ConsumerGroupOffsets.TopicOffsets> topic : topicsToRemove) {
            entry.getValue().consumerGroupOffsets.remove(topic);
        }
        return entry;
    }
}

