/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.connect.ConnectClusterMetadata;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilter;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.PATCH;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import io.confluent.controlcenter.rest.res.KafkaClusterListResponse;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.util.PrincipalUtils;
import io.confluent.controlcenter.util.ScopeUtils;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/2.0/clusters/")
@Produces(value={"application/json"})
public class ClusterResource {
    private static final Logger log = LoggerFactory.getLogger(ClusterResource.class);
    private final ClusterMetadataDao clusterMetadata;
    private final ControlCenterConfig controlCenterConfig;
    private final KsqlClusterMetadata ksqlClusterMetadata;
    private final SchemaRegistryClusterMetadata schemaRegistryClusterMetadata;
    private final ConnectClusterMetadata connectClusterMetadata;
    @Context
    private ScopedServiceVisibilityFilter scopedServiceVisibilityFilter;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public ClusterResource(ClusterMetadataDao clusterMetadata, ControlCenterConfig controlCenterConfig, KsqlClusterMetadata ksqlClusterMetadata, ConnectClusterMetadata connectClusterMetadata, SchemaRegistryClusterMetadata schemaRegistryClusterMetadata) {
        this.clusterMetadata = clusterMetadata;
        this.controlCenterConfig = controlCenterConfig;
        this.ksqlClusterMetadata = ksqlClusterMetadata;
        this.connectClusterMetadata = connectClusterMetadata;
        this.schemaRegistryClusterMetadata = schemaRegistryClusterMetadata;
    }

    @GET
    @Path(value="/connect")
    public List<ConnectCluster> connectClusters() {
        return this.scopedServiceVisibilityFilter.filterConnectClusters(this.connectClusterMetadata.getClusters());
    }

    @GET
    @Path(value="/ksql")
    public List<KsqlCluster> ksqlClusters() {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.ksql.enable").booleanValue()) {
            return ImmutableList.of();
        }
        return this.scopedServiceVisibilityFilter.filterKsqlClusters(this.ksqlClusterMetadata.getClusters());
    }

    @GET
    @Path(value="/schema-registry")
    public List<SchemaRegistryCluster> schemaRegistryClusters() {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.schema.registry.enable").booleanValue()) {
            return ImmutableList.of();
        }
        return this.scopedServiceVisibilityFilter.filterSchemaRegistryClusters(this.schemaRegistryClusterMetadata.getClusters());
    }

    @GET
    @Path(value="/kafka")
    public List<KafkaCluster> kafka(@Context SecurityContext securityContext) {
        TokenCredential cred = TokenCredential.makeCredentialFromJwtOrNullPrincipal("", (Principal)PrincipalUtils.jwtPrincipalOrNull(securityContext));
        List<KafkaCluster> unfilteredKafkaClusters = this.clusterMetadata.getKafkaClusters(cred);
        return this.scopedServiceVisibilityFilter.filterKafkaClusters(unfilteredKafkaClusters);
    }

    @GET
    @Path(value="/kafka/display/{context}")
    public KafkaClusterListResponse kafkaDisplay(@PathParam(value="context") String contextStr) {
        Controlcenter.ClusterContext context;
        String contextName = contextStr.toUpperCase().replace('-', '_');
        try {
            context = Controlcenter.ClusterContext.valueOf((String)contextName);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException();
        }
        switch (context) {
            case STREAM_MONITORING: {
                return this.filteredKafkaClusterList(this.clusterMetadata.getKafkaClustersForStreamMonitoring());
            }
            case CLUSTER_MANAGEMENT: {
                return this.filteredKafkaClusterList(this.clusterMetadata.getKafkaClustersForManagement());
            }
        }
        return new KafkaClusterListResponse(null, Collections.emptyList());
    }

    @PATCH
    @Path(value="/kafka/{clusterId}")
    @Consumes(value={"application/merge-patch+json"})
    public void patchKafka(@Context SecurityContext securityContext, @PathParam(value="clusterId") String clusterId, KafkaCluster updatedCluster) throws Exception {
        if (updatedCluster.clusterId != null && !updatedCluster.clusterId.equals(clusterId)) {
            throw new BadRequestException("The provided clusterId does not match the resource.");
        }
        log.info("Updating metadata for cluster {}: {}", (Object)clusterId, (Object)updatedCluster);
        TokenCredential cred = TokenCredential.makeCredentialFromJwtOrNullPrincipal(clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull(securityContext));
        this.clusterMetadata.externalUpdateKafkaCluster(clusterId, updatedCluster, TimeUnit.SECONDS.toMillis(30L), cred);
    }

    private KafkaClusterListResponse filteredKafkaClusterList(KafkaClusterListResponse listResponse) {
        ImmutableList filtered = ImmutableList.copyOf(this.scopedPermissions.getAllVisible(listResponse.clusters.stream().collect(Collectors.toMap(c -> c, c -> ScopeUtils.buildKafkaScope(c.clusterId)))));
        Set filteredIds = filtered.stream().map(c -> c.clusterId).collect(Collectors.toSet());
        String defaultClusterId = listResponse.defaultClusterId;
        if (filtered.isEmpty()) {
            defaultClusterId = null;
        } else if (defaultClusterId != null && !filteredIds.contains(defaultClusterId)) {
            defaultClusterId = ((KafkaClusterDisplay)filtered.iterator().next()).clusterId;
        }
        return new KafkaClusterListResponse(defaultClusterId, (List<KafkaClusterDisplay>)filtered);
    }
}

