/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.MoreObjects;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.rest.TokenCredential;
import java.security.Principal;
import java.util.Objects;

public class CompoundClusterTokenCredential
extends TokenCredential {
    public final String secondaryClusterId;

    private CompoundClusterTokenCredential(String kafkaClusterId, String secondaryClusterId, String token, String subject) {
        super(kafkaClusterId, token, subject);
        this.secondaryClusterId = secondaryClusterId;
    }

    public static CompoundClusterTokenCredential makeCredential(String kafkaClusterId, String secondaryClusterId) {
        return new CompoundClusterTokenCredential(kafkaClusterId, secondaryClusterId, null, null);
    }

    public static CompoundClusterTokenCredential makeCredentialFromJwtOrNullPrincipal(String kafkaClusterId, String secondaryClusterId, Principal principal) {
        if (!(principal instanceof JwtPrincipal)) {
            return CompoundClusterTokenCredential.makeCredential(kafkaClusterId, secondaryClusterId);
        }
        JwtPrincipal p = (JwtPrincipal)principal;
        return new CompoundClusterTokenCredential(kafkaClusterId, secondaryClusterId, p.getJwt(), p.getName());
    }

    public static CompoundClusterTokenCredential makeCredentialFromJwtPrincipal(String kafkaClusterId, String secondaryClusterId, JwtPrincipal principal) {
        if (principal == null) {
            throw new IllegalArgumentException("invalid token");
        }
        return new CompoundClusterTokenCredential(kafkaClusterId, secondaryClusterId, principal.getJwt(), principal.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompoundClusterTokenCredential that = (CompoundClusterTokenCredential)o;
        return Objects.equals(this.secondaryClusterId, that.secondaryClusterId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.secondaryClusterId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kafkaClusterId", (Object)this.cluster).add("secondaryClusterId", (Object)this.secondaryClusterId).add("token", (Object)this.token).add("subject", (Object)this.subject).toString();
    }
}

