/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.connect.ConnectClusterMetadata;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.rest.ProxyServlet;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.api.Request;

public class ConnectProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final String pathSpec = "/api/connect/*";
    private final Random random = new Random();
    private final Map<String, HttpCredential> credentialsLookup;
    private final ServiceHealthCheck connectHealthCheck;

    @Inject
    public ConnectProxyServlet(ConnectClusterMetadata connectClusterMetadata, @ServiceHealthCheckModule.ConnectHealthCheck ServiceHealthCheck connectHealthCheck) {
        this.credentialsLookup = connectClusterMetadata.getCredentials();
        this.connectHealthCheck = connectHealthCheck;
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        this.maybeAddBasicAuthHeader(clientRequest, proxyRequest, this.credentialsLookup);
    }

    @Override
    public String getPathSpec() {
        return pathSpec;
    }

    @Override
    public String lookupEndpoint(String connectClusterName) {
        List<String> urls = this.connectHealthCheck.getHealthyUrls(connectClusterName);
        if (urls == null) {
            return null;
        }
        if (urls.isEmpty()) {
            throw new RuntimeException("all nodes in Connect cluster '" + connectClusterName + "' are down");
        }
        return ProxyServlet.normalizeUrlProtocol(urls.get(this.random.nextInt(urls.size())));
    }
}

