/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.rest.AbstractConsumerResource;
import io.confluent.controlcenter.rest.CompoundClusterTokenCredential;
import io.confluent.controlcenter.rest.JacksonEncoder;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.res.OmgDeserializer;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.kafka.clients.consumer.Consumer;

@ServerEndpoint(value="/{version}/{clusterId}/consumer", encoders={JacksonEncoder.class})
public class ConsumerResource
extends AbstractConsumerResource {
    private final ConsumerSupplier<byte[], byte[]> consumerSupplier;

    @Inject
    public ConsumerResource(@RestModule.WebSockets ListeningScheduledExecutorService executorService, @ControlCenterConfigModule.MaxTopicMessageSize Long maxMessageSize, ConsumerSupplier<byte[], byte[]> consumerSupplier, SchemaRegistryClientSupplier<CompoundClusterTokenCredential> schemaRegistryClientSupplier) {
        super(executorService, maxMessageSize, schemaRegistryClientSupplier);
        this.consumerSupplier = consumerSupplier;
    }

    @Override
    Consumer<byte[], byte[]> getConsumer(String clusterId, Session session) {
        return this.consumerSupplier.getConsumer(TokenCredential.makeCredentialFromJwtOrNullPrincipal(clusterId, session.getUserPrincipal()));
    }

    @Override
    public OmgDeserializer getDeserializer(SchemaRegistryClient client) {
        return new OmgDeserializer(client);
    }
}

