/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.annotation.Environment;
import io.confluent.controlcenter.annotation.Mode;
import io.confluent.controlcenter.client.ConfigurableClient;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.data.ScopedKafkaMetadataDao;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilter;
import io.confluent.controlcenter.data.ScopedServiceVisibilityFilterFactory;
import io.confluent.controlcenter.data.ServiceVisibilityFilter;
import io.confluent.controlcenter.rest.ApplicationBase;
import io.confluent.controlcenter.rest.AvailableResourceFilter;
import io.confluent.controlcenter.rest.CustomHeaderFilter;
import io.confluent.controlcenter.rest.JsonParseExceptionMapper;
import io.confluent.controlcenter.rest.ModifiableResource;
import io.confluent.controlcenter.rest.ProxyServlet;
import io.confluent.controlcenter.rest.ProxyUriValidationFilter;
import io.confluent.controlcenter.rest.ReadOnlyRolesFilter;
import io.confluent.controlcenter.rest.RestSecuritySetup;
import io.confluent.controlcenter.rest.ScopedKafkaMetadataDaoFactory;
import io.confluent.controlcenter.rest.ScopedPermissionsFactory;
import io.confluent.controlcenter.rest.StaticContentFilter;
import io.confluent.controlcenter.rest.jackson.KafkaModule;
import io.confluent.controlcenter.rest.jackson.ProtoJsonSerializerModule;
import io.confluent.controlcenter.ssl.SslHolder;
import io.confluent.controlcenter.ssl.SslUtils;
import io.confluent.controlcenter.util.ReflectionsUtils;
import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactory;
import io.confluent.rest.auth.AuthUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.Path;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.ParamConverterProvider;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ControlCenterApplication
extends Application<RestConfig>
implements ApplicationBase {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterApplication.class);
    private static final String staticResourcePath = "io/confluent/controlcenter/rest/static";
    private static final List<String> securedPathSec = ImmutableList.of((Object)"/2.0/*", (Object)"/3.0/*", (Object)"/api/*");
    private static final List<String> unsecuredPathSec = ImmutableList.of((Object)"/2.0/feature/flags", (Object)"/3.0/license/payload", (Object)"/api/metadata/*");
    private static final String nonApiRequests = "^/(?!(2.0/|3.0/|api/permissions|api/service-health/)).*";
    private static final List<String> nonProxyPathsRegex = Stream.of("/api/permissions", "/api/service-health/.*").collect(Collectors.toList());
    private final ControlCenterConfig controlCenterConfig;
    private Injector injector;
    private final Reflections reflections;
    private Mode.ModeType modeType;
    private final Predicate<Class<?>> predicate = aClass -> {
        int modifiers = aClass.getModifiers();
        Environment env = aClass.getAnnotation(Environment.class);
        Mode mode = aClass.getAnnotation(Mode.class);
        return !(Modifier.isAbstract(modifiers) || env != null && env.environment() != Environment.EnvType.ON_PREM || mode != null && mode.mode() != this.modeType || this.injector.getInstance(aClass) == null);
    };

    @Inject
    public ControlCenterApplication(RestConfig config, ControlCenterConfig controlCenterConfig, Mode.ModeType modeType, Injector injector, Reflections reflections) {
        super(config, controlCenterConfig.getString("confluent.controlcenter.ui.basepath"));
        this.controlCenterConfig = controlCenterConfig;
        this.modeType = modeType;
        this.injector = injector;
        this.reflections = reflections;
    }

    protected ResourceCollection getStaticResources() {
        return new ResourceCollection(new Resource[]{new ModifiableResource(Resource.newClassPathResource((String)staticResourcePath), this.controlCenterConfig)});
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
        List<String> proxyPathRegex = this.getSubTypesOf(ProxyServlet.class).stream().filter(ProxyServlet::enabled).map(ProxyServlet::getPathSpec).map(pathSpec -> pathSpec.replace("*", ".*")).collect(Collectors.toList());
        context.addFilter(new FilterHolder((Filter)new ProxyUriValidationFilter(proxyPathRegex, nonProxyPathsRegex)), "/api/*", null);
        context.addFilter(new FilterHolder((Filter)this.injector.getInstance(ReadOnlyRolesFilter.class)), "/*", null);
        context.addFilter(new FilterHolder((Filter)this.injector.getInstance(AvailableResourceFilter.class)), "/*", null);
        context.addFilter(new FilterHolder((Filter)this.injector.getInstance(CustomHeaderFilter.class)), "/*", null);
    }

    protected void configurePostResourceHandling(ServletContextHandler context) {
        long authTimeout = this.controlCenterConfig.getLong("confluent.controlcenter.auth.session.expiration.ms");
        if (authTimeout > 0L) {
            context.getSessionHandler().setMaxInactiveInterval((int)TimeUnit.SECONDS.toSeconds(authTimeout));
        }
        context.addFilter(new FilterHolder((Filter)this.injector.getInstance(StaticContentFilter.class)), "/*", null);
        this.configureProxyServices(context);
        this.configureErrorHandler(context);
    }

    protected void registerWebSocketEndpoints(ServerContainer container) {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.topic.inspection.enable").booleanValue()) {
            return;
        }
        final List<String> allowedOrigins = AuthUtil.isCorsEnabled((RestConfig)this.config) ? Arrays.asList(StringUtil.csvSplit((String)this.config.getString("access.control.allow.origin"))) : null;
        this.getTypesAnnotatedWith(ServerEndpoint.class).forEach(serverEndpoint -> {
            Class<?> endpointClass = serverEndpoint.getClass();
            String value = endpointClass.getAnnotation(ServerEndpoint.class).value();
            Class[] encoders = endpointClass.getAnnotation(ServerEndpoint.class).encoders();
            log.info("adding websocket endpoint " + endpointClass.getSimpleName());
            try {
                container.addEndpoint(ServerEndpointConfig.Builder.create(endpointClass, (String)value).configurator(new ServerEndpointConfig.Configurator(){

                    public <T> T getEndpointInstance(Class<T> endpointClass) {
                        return (T)ControlCenterApplication.this.injector.getInstance(endpointClass);
                    }

                    public boolean checkOrigin(String originHeaderValue) {
                        if (allowedOrigins == null) {
                            return true;
                        }
                        if (StringUtil.isBlank((String)originHeaderValue)) {
                            return true;
                        }
                        if (allowedOrigins.contains("*")) {
                            return true;
                        }
                        return allowedOrigins.stream().anyMatch(originHeaderValue::equalsIgnoreCase);
                    }
                }).encoders(Arrays.asList(encoders)).build());
            }
            catch (DeploymentException e) {
                log.error("unable to deploy websocket endpoints", (Throwable)e);
            }
        });
    }

    protected void configureSecurityHandler(ServletContextHandler context) {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        RestSecuritySetup restSecuritySetup = (RestSecuritySetup)this.injector.getInstance(RestSecuritySetup.class);
        if (restSecuritySetup.getRealm() != null) {
            securedPathSec.forEach(pathSec -> securityHandler.addConstraintMapping(AuthUtil.createSecuredConstraint((RestConfig)this.config, (String)pathSec)));
            unsecuredPathSec.forEach(pathSec -> securityHandler.addConstraintMapping(AuthUtil.createUnsecuredConstraint((RestConfig)this.config, (String)pathSec)));
        }
        securityHandler.setRealmName(restSecuritySetup.getRealm());
        securityHandler.setAuthenticator((Authenticator)restSecuritySetup.getAuthenticator());
        securityHandler.setLoginService(restSecuritySetup.getLoginService());
        securityHandler.setIdentityService(restSecuritySetup.getIdentityService());
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        context.setSecurityHandler((SecurityHandler)securityHandler);
    }

    protected void registerJsonProvider(Configurable<?> config, RestConfig restConfig, boolean registerExceptionMapper) {
        super.registerJsonProvider(config, restConfig, false);
        config.register(JsonParseExceptionMapper.class);
    }

    public void setupResources(Configurable<?> config, RestConfig appConfig) {
        this.getSubTypesOf(ExceptionMapper.class).forEach(arg_0 -> config.register(arg_0));
        config.register(JsonMappingExceptionMapper.class);
        this.getTypesAnnotatedWith(Path.class).forEach(arg_0 -> config.register(arg_0));
        this.getSubTypesOf(ParamConverterProvider.class).forEach(arg_0 -> config.register(arg_0));
        config.register((Object)new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return ControlCenterApplication.this.getJsonMapper();
            }
        });
        config.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bindFactory(ScopedPermissionsFactory.class).to(ScopedPermissions.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bind(ControlCenterApplication.this.injector.getInstance(PermissionsService.class)).to(PermissionsService.class);
                this.bindFactory(ScopedKafkaMetadataDaoFactory.class).to(ScopedKafkaMetadataDao.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bind(ControlCenterApplication.this.injector.getInstance(KafkaMetadataDao.class)).to(KafkaMetadataDao.class);
                this.bindFactory(ScopedServiceVisibilityFilterFactory.class).to(ScopedServiceVisibilityFilter.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bind(ControlCenterApplication.this.injector.getInstance(ServiceVisibilityFilter.class)).to(ServiceVisibilityFilter.class);
            }
        });
        config.property("jersey.config.servlet.filter.staticContentRegex", (Object)nonApiRequests);
    }

    protected ObjectMapper getJsonMapper() {
        ObjectMapper om = super.getJsonMapper();
        om.registerModule((Module)this.injector.getInstance(ProtoJsonSerializerModule.class));
        om.registerModule((Module)new KafkaModule());
        om.registerModule((Module)new Jdk8Module());
        return om;
    }

    private void configureProxyServices(ServletContextHandler context) {
        SslHolder serverSslHolder = (SslHolder)this.injector.getInstance(Key.get(SslHolder.class, ControlCenterConfigModule.ServerSslHolder.class));
        List proxySslHolders = (List)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<List<SslHolder>>(){}));
        SslContextFactory baseSslContextFactory = SslFactory.createSslContextFactory((SslConfig)this.config.getBaseSslConfig());
        SslUtils.JettySslUtils.buildJettySslContext(baseSslContextFactory, serverSslHolder, proxySslHolders, this.controlCenterConfig);
        for (SslContextFactory sslContextFactory : this.server.getSslContextFactories().values()) {
            SslUtils.JettySslUtils.buildJettySslContext(sslContextFactory, serverSslHolder, proxySslHolders, this.controlCenterConfig);
        }
        int reqBufferSize = this.controlCenterConfig.getInt("confluent.controlcenter.request.buffer.size.bytes");
        this.getSubTypesOf(ProxyServlet.class).stream().filter(ProxyServlet::enabled).forEach(proxyServlet -> {
            context.addServlet(new ServletHolder((Servlet)proxyServlet), proxyServlet.getPathSpec());
            proxyServlet.setRequestBufferSize(reqBufferSize);
            proxyServlet.setSslContextFactory(baseSslContextFactory);
        });
        this.getSubTypesOf(ConfigurableClient.class).stream().filter(Objects::nonNull).forEach(configurableClient -> configurableClient.setSslContextFactory(baseSslContextFactory));
        ServiceVisibilityFilter serviceVisibilityFilter = (ServiceVisibilityFilter)this.injector.getInstance(ServiceVisibilityFilter.class);
        serviceVisibilityFilter.setSslContextFactory(baseSslContextFactory);
    }

    private <T> ImmutableSet<T> getSubTypesOf(Class<T> type) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ReflectionsUtils.getSubTypesOf(this.reflections, type, builder, this.predicate, aClass -> this.injector.getInstance(aClass));
        return builder.build();
    }

    public ApplicationServer<?> getServer() {
        return this.server;
    }

    private ImmutableSet<Object> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ReflectionsUtils.getTypesAnnotatedWith(this.reflections, annotation, builder, this.predicate, aClass -> this.injector.getInstance(aClass));
        return builder.build();
    }

    @VisibleForTesting
    URI getServerUri() {
        return this.server.getURI();
    }
}

