/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.confluent.controlcenter.kafka.KafkaRestManager;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;

public class KafkaRestProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final String pathSpec = "/api/kafka-rest/*";
    private final Random random = new Random();
    private final KafkaRestManager kafkaRestManager;

    @Inject
    public KafkaRestProxyServlet(KafkaRestManager kafkaRestManager) {
        this.kafkaRestManager = kafkaRestManager;
    }

    @Override
    public String getPathSpec() {
        return pathSpec;
    }

    @Override
    public String lookupEndpoint(String clusterId) {
        List<String> endpoints = this.kafkaRestManager.getEndpoints(clusterId);
        return endpoints != null && endpoints.size() > 0 ? endpoints.get(this.random.nextInt(endpoints.size())) : null;
    }

    @Override
    protected void handleComplete(Result result, String clusterId) {
        Preconditions.checkNotNull((Object)clusterId);
        if (result.isFailed() && result.getResponse().getStatus() == 0 && !(result.getResponseFailure() instanceof TimeoutException)) {
            Request request = result.getRequest();
            this.kafkaRestManager.markEndpointUnhealthy(clusterId, String.format("%s://%s:%s", request.getScheme(), request.getHost(), request.getPort()));
        }
    }
}

