/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Request;

public class KsqlProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final String pathSpec = "/api/ksql/*";
    private static final String WS_REDIRECT = "ws-redirect";
    private static final String WEBSOCKET_KEYWORD = "websocket";
    private final Random random = new Random();
    private final ControlCenterConfig controlCenterConfig;
    private final Map<String, HttpCredential> credentialsLookup;
    private final ServiceHealthCheck ksqlHealthCheck;

    @Inject
    public KsqlProxyServlet(ControlCenterConfig controlCenterConfig, KsqlClusterMetadata ksqlClusterMetadata, @ServiceHealthCheckModule.KsqlHealthCheck ServiceHealthCheck ksqlHealthCheck) {
        this.controlCenterConfig = controlCenterConfig;
        this.credentialsLookup = ksqlClusterMetadata.getCredentials();
        this.ksqlHealthCheck = ksqlHealthCheck;
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        this.maybeAddBasicAuthHeader(clientRequest, proxyRequest, this.credentialsLookup);
    }

    @Override
    protected void onProxyRewriteFailed(HttpServletRequest clientRequest, HttpServletResponse clientResponse) {
        String location = (String)clientRequest.getAttribute(WS_REDIRECT);
        if (location == null) {
            clientResponse.setStatus(404);
        } else {
            clientResponse.setStatus(302);
            clientResponse.setHeader("Location", location);
        }
    }

    @Override
    protected String rewriteTarget(HttpServletRequest clientRequest) {
        String targetUri = this.extractProxyUri(clientRequest);
        if (targetUri == null) {
            return null;
        }
        if ("Upgrade".equals(clientRequest.getHeader("Connection")) && WEBSOCKET_KEYWORD.equals(clientRequest.getHeader("Upgrade"))) {
            clientRequest.setAttribute(WS_REDIRECT, (Object)targetUri);
            return null;
        }
        return targetUri;
    }

    @Override
    public boolean enabled() {
        return this.controlCenterConfig.getBoolean("confluent.controlcenter.ksql.enable");
    }

    @Override
    public String getPathSpec() {
        return pathSpec;
    }

    @Override
    public String lookupEndpoint(String ksqlClusterName) {
        List<String> endpoints = this.ksqlHealthCheck.getHealthyUrls(ksqlClusterName);
        if (endpoints == null) {
            return null;
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("all nodes in KSQL cluster '" + ksqlClusterName + "' are down");
        }
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }
}

