/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.client.MetadataServiceClient;
import io.confluent.controlcenter.rest.AbstractTargetProxyServlet;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.api.Request;

public class MetadataProxyServlet
extends AbstractTargetProxyServlet {
    private static final String pathSpec = "/api/metadata/*";
    private final Random random = new Random();
    private static final String C3_TOKEN_MAX_LIFE_HEADER_KEY = "X-C3-Token-Max-Life";
    private final SingleServiceHealthCheck mdsHealthCheck;
    private MetadataServiceClient metadataServiceClient;
    private final Long bearerTokenMaxLifeMs;

    @Inject
    public MetadataProxyServlet(@ServiceHealthCheckModule.MetadataServiceHealthCheck SingleServiceHealthCheck mdsHealthCheck, @Nullable MetadataServiceClient metadataServiceClient, @ControlCenterConfigModule.BearerTokenMaxLife Long bearerTokenMaxLifeMs) {
        this.mdsHealthCheck = mdsHealthCheck;
        this.bearerTokenMaxLifeMs = bearerTokenMaxLifeMs;
        this.metadataServiceClient = metadataServiceClient;
    }

    @Override
    public boolean enabled() {
        return this.metadataServiceClient != null;
    }

    @Override
    public String getPathSpec() {
        return pathSpec;
    }

    @Override
    protected String getEndpoint() {
        List<String> endpoints = this.mdsHealthCheck.getHealthyUrls();
        if (endpoints == null) {
            return null;
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("all nodes in MetadataService cluster are down");
        }
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }

    private void addTokenMaxLifeHeader(HttpServletRequest clientRequest, Request proxyRequest) {
        proxyRequest.header(C3_TOKEN_MAX_LIFE_HEADER_KEY, null);
        proxyRequest.header(C3_TOKEN_MAX_LIFE_HEADER_KEY, String.valueOf(this.bearerTokenMaxLifeMs));
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        this.addTokenMaxLifeHeader(clientRequest, proxyRequest);
    }
}

