/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Inject;
import io.confluent.controlcenter.kafka.ProducerSupplier;
import io.confluent.controlcenter.rest.AbstractProducerResource;
import io.confluent.controlcenter.rest.JacksonEncoder;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.rest.TokenCredential;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.kafka.clients.producer.KafkaProducer;

@ServerEndpoint(value="/{version}/{clusterId}/producer", encoders={JacksonEncoder.class})
public class ProducerResource
extends AbstractProducerResource {
    private final ProducerSupplier<byte[], byte[]> producerSupplier;

    @Inject
    public ProducerResource(@RestModule.WebSockets ListeningScheduledExecutorService executorService, ProducerSupplier<byte[], byte[]> producerSupplier) {
        super(executorService);
        this.producerSupplier = producerSupplier;
    }

    @Override
    KafkaProducer<byte[], byte[]> getProducer(String clusterId, Session session) {
        return this.producerSupplier.getProducer(TokenCredential.makeCredentialFromJwtOrNullPrincipal(clusterId, session.getUserPrincipal()));
    }
}

