/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProxyUriValidationFilter
implements Filter {
    private final List<String> proxyPathRegex;
    private final List<String> nonApiRequestRegex;

    public ProxyUriValidationFilter(List<String> proxyPathRegex, List<String> nonApiRequestRegex) {
        this.proxyPathRegex = proxyPathRegex;
        this.nonApiRequestRegex = nonApiRequestRegex;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestPath = this.getRequestPath(request);
        if (!this.nonApiRequestRegex.stream().anyMatch(requestPath::matches)) {
            if (!this.proxyPathRegex.stream().anyMatch(requestPath::matches)) {
                PrintWriter out = response.getWriter();
                response.setStatus(404);
                out.flush();
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getRequestPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath != null && !contextPath.isEmpty() && request.getRequestURI().startsWith(contextPath)) {
            return request.getRequestURI().substring(contextPath.length());
        }
        return request.getRequestURI();
    }
}

