/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.OAuthBearerAuthenticator;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.rest.RestSecuritySetup;
import io.confluent.controlcenter.rest.SessionBasicAuthenticator;
import io.confluent.monitoring.common.Clock;
import io.confluent.monitoring.common.SystemClock;
import io.confluent.rest.RestConfig;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;

public class RestModule
implements Module {
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    @WebSockets
    public ListeningScheduledExecutorService getScheduledExecutorService() {
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).build()));
    }

    @Provides
    @Inject
    public RestSecuritySetup restSecuritySetup(ControlCenterConfig controlCenterConfig, RestConfig restConfig, ControlCenterRbacConfig rbacConfig, SystemClock systemClock) {
        String realm = null;
        Object authenticator = null;
        JAASLoginService loginService = null;
        IdentityService identityService = null;
        String authMethod = restConfig.getString("authentication.method");
        String realmConfig = restConfig.getString("authentication.realm");
        long authSessionExpirationMs = controlCenterConfig.getLong("confluent.controlcenter.auth.session.expiration.ms");
        if (rbacConfig.isRbacEnabled() && !"BEARER".equals(authMethod)) {
            throw new ConfigException("confluent.controlcenter.rest.authentication.method=BEARER is required when RBAC is enabled");
        }
        if ("BASIC".equals(authMethod)) {
            realm = realmConfig;
            authenticator = authSessionExpirationMs <= 0L ? new BasicAuthenticator() : new SessionBasicAuthenticator((Clock)systemClock, authSessionExpirationMs);
            loginService = new JAASLoginService(realm);
        } else if ("BEARER".equals(authMethod)) {
            realm = realmConfig;
            String issuer = controlCenterConfig.getString("confluent.controlcenter.auth.bearer.issuer");
            String publicKeyPath = controlCenterConfig.getString("public.key.path");
            String rolesClaim = controlCenterConfig.getString("confluent.controlcenter.auth.bearer.roles.claim");
            if (Strings.isNullOrEmpty((String)publicKeyPath)) {
                throw new ConfigException("Must provide 'public.key.path' when using 'confluent.controlcenter.rest.authentication.method=BEARER'");
            }
            authenticator = new OAuthBearerAuthenticator();
            loginService = new JwtLoginService(realm, issuer, publicKeyPath, rolesClaim);
        }
        return new RestSecuritySetup(realm, (LoginAuthenticator)authenticator, (LoginService)loginService, identityService);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface FallbackTopicReplicationFactor {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface BrokerConfigsEditEnabled {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SchemaRegistry {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface WebSockets {
    }
}

