/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

class StaticContentFilter
implements Filter {
    protected final ControlCenterConfig controlCenterConfig;

    @Inject
    public StaticContentFilter(ControlCenterConfig config) {
        this.controlCenterConfig = config;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String basePath = this.controlCenterConfig.getString("confluent.controlcenter.ui.basepath");
        String path = ((HttpServletRequest)request).getRequestURI();
        if (path.equals(basePath) || path.startsWith(basePath + "dist/") || path.startsWith(basePath + "api/")) {
            chain.doFilter(request, response);
        } else {
            request.getRequestDispatcher("/").forward(request, response);
        }
    }

    public void destroy() {
    }
}

