/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.MoreObjects;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.rest.AdminVisitor;
import io.confluent.controlcenter.rest.ClusterCredential;
import io.confluent.controlcenter.rest.Util;
import java.security.Principal;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;

public class TokenCredential
extends ClusterCredential {
    public final String token;
    public final String subject;

    public TokenCredential(String cluster, String token, String subject) {
        super(cluster);
        this.token = token;
        this.subject = subject;
    }

    public static TokenCredential makeCredential(String clusterId) {
        return new TokenCredential(clusterId, null, null);
    }

    public static TokenCredential makeCredentialFromJwtOrNullPrincipal(String clusterId, Principal principal) {
        if (!(principal instanceof JwtPrincipal)) {
            return TokenCredential.makeCredential(clusterId);
        }
        JwtPrincipal p = (JwtPrincipal)principal;
        return new TokenCredential(clusterId, p.getJwt(), p.getName());
    }

    public static TokenCredential makeCredentialFromJwtPrincipal(String clusterId, Principal principal) {
        JwtPrincipal pr = (JwtPrincipal)principal;
        if (pr == null) {
            throw new IllegalArgumentException("invalid token");
        }
        return new TokenCredential(clusterId, pr.getJwt(), pr.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenCredential that = (TokenCredential)o;
        return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.token, that.token) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.token, this.subject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("token", (Object)this.token).add("subject", (Object)this.subject).toString();
    }

    @Override
    public Admin accept(AdminVisitor adminVisitor) {
        return adminVisitor.visit(this);
    }

    public boolean isExpired() {
        return Util.getTokenLifetimeMs(this.token) < System.currentTimeMillis();
    }
}

