/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.Metric;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.req.RangeRequest;
import io.confluent.controlcenter.rollup.Rollup;
import io.confluent.monitoring.record.Monitoring;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class Util {
    private static final JwtConsumer NO_VALIDATION_JWT_CONSUMER = new JwtConsumerBuilder().setSkipAllValidators().setSkipAllDefaultValidators().setDisableRequireSignature().setSkipSignatureVerification().build();

    public static ArrayList<Object> extractValues(List<Monitoring.MonitoringMessage> monitoringMessages, long rollup, long startTimeMs, long stopTimeMs, int max, Metric metric) {
        long currentWindow;
        ArrayList result = Lists.newArrayList();
        Long startWindow = stopTimeMs;
        if (monitoringMessages.size() > 0) {
            startWindow = Rollup.window(rollup, monitoringMessages.get(0).getWindow());
        }
        while (startTimeMs < startWindow && result.size() < max) {
            result.add(null);
            startTimeMs += rollup;
        }
        if (result.size() < max) {
            if (monitoringMessages.size() > 0) {
                result.add(metric.getValue(monitoringMessages.get(0)));
            } else {
                result.add(null);
            }
        }
        for (int i = 1; i < monitoringMessages.size() && result.size() < max && (currentWindow = Rollup.window(rollup, monitoringMessages.get(i).getWindow())) <= stopTimeMs; ++i) {
            long previousWindow = Rollup.window(rollup, monitoringMessages.get(i - 1).getWindow());
            long steps = (currentWindow - previousWindow) / rollup;
            int j = 0;
            while ((long)j < steps - 1L && result.size() < max) {
                result.add(null);
                ++j;
            }
            if (result.size() >= max) continue;
            result.add(metric.getValue(monitoringMessages.get(i)));
        }
        if (monitoringMessages.size() > 0) {
            for (long lastTimeMs = Rollup.window(rollup, monitoringMessages.get(monitoringMessages.size() - 1).getWindow()); lastTimeMs < stopTimeMs && result.size() < max; lastTimeMs += rollup) {
                result.add(null);
            }
        }
        return result;
    }

    public static RangeRequest createMergedRangeRequest(Controlcenter.MemberInfo memberInfo, RangeRequest rangeRequest, String defaultClientId, String defaultGroup) {
        RangeRequest out = new RangeRequest(rangeRequest.clusterId, rangeRequest.getRollupAlignedStartTimeMs(), rangeRequest.getRollupAlignedStopTimeMs());
        out.rollup = rangeRequest.rollup;
        out.clientId = Strings.emptyToNull((String)memberInfo.getClientId());
        if (out.clientId == null) {
            out.clientId = defaultClientId;
        }
        out.group = Strings.emptyToNull((String)memberInfo.getGroup());
        if (out.group == null) {
            out.group = defaultGroup;
        }
        out.topic = Strings.emptyToNull((String)memberInfo.getTopicPartition().getTopic());
        if (out.topic != null) {
            out.partition = memberInfo.getTopicPartition().getPartition();
        } else {
            out.topic = Strings.emptyToNull((String)memberInfo.getTopic());
        }
        return out;
    }

    public static long getTokenLifetimeMs(String bearerToken) {
        try {
            JwtClaims jwtClaims = NO_VALIDATION_JWT_CONSUMER.processToClaims(bearerToken);
            return jwtClaims.getExpirationTime().getValueInMillis();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new ConfigException("Failed to get token lifetime");
        }
    }

    public static <K> List<TokenCredential> getExpiredTokens(Set<K> keys) {
        return keys.stream().filter(key -> key instanceof TokenCredential && ((TokenCredential)key).token != null && ((TokenCredential)key).isExpired()).map(key -> (TokenCredential)key).collect(Collectors.toList());
    }
}

