/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.StdConverter;
import io.confluent.controlcenter.rest.jackson.JsonStrict;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;

public class KafkaModule
extends SimpleModule {
    public KafkaModule() {
        super("KafkaModule");
        this.setMixInAnnotation(ConsumerRecord.class, ConsumerRecordMixin.class);
        this.setMixInAnnotation(Header.class, HeaderMixin.class);
        this.setMixInAnnotation(ConfigEntry.ConfigSynonym.class, ConfigSynonymMixin.class);
        this.setMixInAnnotation(ConfigEntry.class, ConfigEntryMixin.class);
        this.setMixInAnnotation(Config.class, ConfigMixin.class);
        this.setMixInAnnotation(NewTopic.class, NewTopicMixin.class);
        this.setMixInAnnotation(NewMirrorTopic.class, NewMirrorTopicMixin.class);
        this.setMixInAnnotation(Node.class, NodeMixin.class);
        this.setMixInAnnotation(TopicDescription.class, TopicDescriptionMixin.class);
        this.setMixInAnnotation(TopicPartitionInfo.class, TopicPartitionInfoMixin.class);
        this.setMixInAnnotation(AclBinding.class, AclBindingMixin.class);
        this.setMixInAnnotation(ResourcePattern.class, ResourcePatternMixin.class);
        this.setMixInAnnotation(AccessControlEntry.class, AccessControlEntryMixin.class);
        this.setMixInAnnotation(AclBindingFilter.class, AclBindingFilterMixin.class);
        this.setMixInAnnotation(ResourcePatternFilter.class, ResourcePatternFilterMixin.class);
        this.setMixInAnnotation(AccessControlEntryFilter.class, AccessControlEntryFilterMixin.class);
        this.setMixInAnnotation(ReplicaStatus.class, ReplicaStatusMixin.class);
        this.setMixInAnnotation(ClusterLinkListing.class, ClusterLinkingListingMixin.class);
        this.setMixInAnnotation(NewClusterLink.class, NewClusterLinkMixin.class);
    }

    @JsonStrict
    static abstract class NewClusterLinkMixin {
        @JsonCreator
        NewClusterLinkMixin(@JsonProperty(value="linkName") String linkName, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="configs") Map<String, String> configs) {
        }

        @JsonProperty(value="linkName")
        abstract String linkName();

        @JsonProperty(value="clusterId")
        abstract String clusterId();

        @JsonProperty(value="configs")
        abstract Map<String, String> configs();
    }

    @JsonStrict
    static abstract class ClusterLinkingListingMixin {
        @JsonCreator
        ClusterLinkingListingMixin(@JsonProperty(value="linkName") String linkName, @JsonProperty(value="linkId") UUID linkId, @JsonProperty(value="remoteClusterId") String remoteClusterId, @JsonProperty(value="localClusterId") String localClusterId, @JsonProperty(value="topics") Optional<Collection<String>> topics, @JsonProperty(value="available") boolean available) {
        }

        @JsonProperty(value="linkName")
        abstract String linkName();

        @JsonProperty(value="linkId")
        abstract UUID linkId();

        @JsonProperty(value="remoteClusterId")
        abstract String remoteClusterId();

        @JsonProperty(value="localClusterId")
        abstract String localClusterId();

        @JsonProperty(value="topics")
        abstract Optional<Collection<String>> topics();

        @JsonProperty(value="available")
        abstract boolean available();
    }

    @JsonStrict
    static abstract class ReplicaStatusMixin {
        @JsonCreator
        ReplicaStatusMixin(@JsonProperty(value="brokerId") int brokerId, @JsonProperty(value="isLeader") boolean isLeader, @JsonProperty(value="isObserver") boolean isObserver, @JsonProperty(value="isIsrEligible") boolean isIsrEligible, @JsonProperty(value="isInIsr") boolean isInIsr, @JsonProperty(value="isCaughtUp") boolean isCaughtUp, @JsonProperty(value="logStartOffset") long logStartOffset, @JsonProperty(value="logEndOffset") long logEndOffset, @JsonProperty(value="lastCaughtUpTimeMs") long lastCaughtUpTimeMs, @JsonProperty(value="lastFetchTimeMs") long lastFetchTimeMs, @JsonProperty(value="linkName") Optional<String> linkName) {
        }

        @JsonProperty(value="brokerId")
        abstract int brokerId();

        @JsonProperty(value="isLeader")
        abstract boolean isLeader();

        @JsonProperty(value="isObserver")
        abstract boolean isObserver();

        @JsonProperty(value="isIsrEligible")
        abstract boolean isIsrEligible();

        @JsonProperty(value="isInIsr")
        abstract boolean isInIsr();

        @JsonProperty(value="isCaughtUp")
        abstract boolean isCaughtUp();

        @JsonProperty(value="logStartOffset")
        abstract long logStartOffset();

        @JsonProperty(value="logEndOffset")
        abstract long logEndOffset();

        @JsonProperty(value="lastCaughtUpTimeMs")
        abstract long lastCaughtUpTimeMs();

        @JsonProperty(value="lastFetchTimeMs")
        abstract long lastFetchTimeMs();

        @JsonProperty(value="linkName")
        abstract Optional<String> linkName();
    }

    @JsonStrict
    static abstract class TopicPartitionInfoMixin {
        TopicPartitionInfoMixin() {
        }

        @JsonCreator
        static TopicPartitionInfo ofReplicasAndObservers(@JsonProperty(value="partition") int partition, @JsonProperty(value="leader") Node leader, @JsonProperty(value="replicas") List<Node> replicas, @JsonProperty(value="observers") List<Node> observers, @JsonProperty(value="isr") List<Node> isr) {
            throw new UnsupportedOperationException();
        }

        @JsonProperty(value="partition")
        abstract int partition();

        @JsonProperty(value="leader")
        abstract Node leader();

        @JsonProperty(value="replicas")
        abstract List<Node> replicas();

        @JsonProperty(value="observers")
        abstract List<Node> observers();

        @JsonProperty(value="isr")
        abstract List<Node> isr();
    }

    @JsonStrict
    static abstract class TopicDescriptionMixin {
        @JsonCreator
        TopicDescriptionMixin(@JsonProperty(value="name") String name, @JsonProperty(value="internal") boolean internal, @JsonProperty(value="partitions") List<TopicPartitionInfo> partitions, @JsonSetter(value="authorizedOperations") Set<AclOperation> authorizedOperations) {
        }

        @JsonProperty(value="name")
        abstract String name();

        @JsonProperty(value="internal")
        abstract boolean isInternal();

        @JsonProperty(value="partitions")
        abstract List<TopicPartitionInfo> partitions();

        @JsonGetter(value="authorizedOperations")
        abstract List<AclOperation> authorizedOperations();
    }

    @JsonStrict
    static abstract class NodeMixin {
        @JsonCreator
        NodeMixin(@JsonProperty(value="id") int id, @JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="rack") String rack) {
        }

        @JsonProperty(value="id")
        abstract int id();

        @JsonProperty(value="host")
        abstract String host();

        @JsonProperty(value="port")
        abstract int port();

        @JsonProperty(value="rack")
        abstract String rack();
    }

    @JsonStrict
    static abstract class NewMirrorTopicMixin {
        @JsonCreator
        NewMirrorTopicMixin(@JsonProperty(value="linkName") String linkName, @JsonProperty(value="mirrorTopic") String mirrorTopic) {
        }

        @JsonProperty(value="linkName")
        abstract String linkName();

        @JsonProperty(value="mirrorTopic")
        abstract String mirrorTopic();
    }

    @JsonStrict
    static abstract class NewTopicMixin {
        @JsonCreator
        NewTopicMixin(@JsonProperty(value="name") String name, @JsonProperty(value="numPartitions") int numPartitions, @JsonProperty(value="replicationFactor") short replicationFactor) {
        }

        @JsonProperty(value="name")
        abstract String name();

        @JsonProperty(value="numPartitions")
        abstract int numPartitions();

        @JsonProperty(value="replicationFactor")
        abstract short replicationFactor();

        @JsonProperty(value="configs")
        abstract Map<String, String> configs();

        @JsonSetter(value="configs")
        abstract NewTopic configs(Map<String, String> var1);

        @JsonProperty(value="mirror")
        abstract Optional<NewMirrorTopic> mirror();

        @JsonSetter(value="mirror")
        abstract NewTopic mirror(Optional<NewMirrorTopic> var1);
    }

    @JsonStrict
    static abstract class ConfigMixin {
        @JsonCreator
        ConfigMixin(@JsonProperty(value="entries") Collection<ConfigEntry> entries) {
        }

        @JsonProperty(value="entries")
        abstract Collection<ConfigEntry> entries();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonStrict
    static abstract class ConfigEntryMixin {
        @JsonCreator
        ConfigEntryMixin(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
        }

        @JsonProperty(value="name")
        abstract String name();

        @JsonProperty(value="value")
        abstract String value();

        @JsonProperty(value="source")
        abstract ConfigEntry.ConfigSource source();

        @JsonProperty(value="isSensitive")
        abstract boolean isSensitive();

        @JsonProperty(value="isReadOnly")
        abstract boolean isReadOnly();

        @JsonProperty(value="synonyms")
        abstract List<ConfigEntry.ConfigSynonym> synonyms();
    }

    @JsonStrict
    static abstract class ConfigSynonymMixin {
        @JsonCreator
        ConfigSynonymMixin(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value, @JsonProperty(value="source") ConfigEntry.ConfigSource source) {
        }

        @JsonProperty(value="name")
        abstract String name();

        @JsonProperty(value="value")
        abstract String value();

        @JsonProperty(value="source")
        abstract ConfigEntry.ConfigSource source();
    }

    @JsonStrict
    static abstract class AccessControlEntryFilterMixin {
        @JsonCreator
        AccessControlEntryFilterMixin(@JsonProperty(value="principal") String principal, @JsonProperty(value="host") String host, @JsonProperty(value="operation") AclOperation operation, @JsonProperty(value="permissionType") AclPermissionType permissionType) {
        }

        @JsonProperty(value="principal")
        abstract String principal();

        @JsonProperty(value="host")
        abstract String host();

        @JsonProperty(value="operation")
        abstract AclOperation operation();

        @JsonProperty(value="permissionType")
        abstract AclPermissionType permissionType();
    }

    @JsonStrict
    static abstract class ResourcePatternFilterMixin {
        @JsonCreator
        ResourcePatternFilterMixin(@JsonProperty(value="resourceType") ResourceType resourceType, @JsonProperty(value="name") String name, @JsonProperty(value="patternType") PatternType patternType) {
        }

        @JsonProperty(value="resourceType")
        abstract ResourceType resourceType();

        @JsonProperty(value="name")
        abstract String name();

        @JsonProperty(value="patternType")
        abstract PatternType patternType();
    }

    @JsonStrict
    static abstract class AclBindingFilterMixin {
        @JsonCreator
        public AclBindingFilterMixin(@JsonProperty(value="patternFilter") ResourcePatternFilter patternFilter, @JsonProperty(value="entryFilter") AccessControlEntryFilter entryFilter) {
        }

        @JsonProperty(value="patternFilter")
        abstract ResourcePatternFilter patternFilter();

        @JsonProperty(value="entryFilter")
        abstract AccessControlEntryFilter entryFilter();
    }

    @JsonStrict
    static abstract class AccessControlEntryMixin {
        @JsonCreator
        AccessControlEntryMixin(@JsonProperty(value="principal") String principal, @JsonProperty(value="host") String host, @JsonProperty(value="operation") AclOperation operation, @JsonProperty(value="permissionType") AclPermissionType permissionType) {
        }

        @JsonProperty(value="principal")
        abstract String principal();

        @JsonProperty(value="host")
        abstract String host();

        @JsonProperty(value="operation")
        abstract AclOperation operation();

        @JsonProperty(value="permissionType")
        abstract AclPermissionType permissionType();
    }

    @JsonStrict
    static abstract class ResourcePatternMixin {
        @JsonCreator
        public ResourcePatternMixin(@JsonProperty(value="resourceType") ResourceType resourceType, @JsonProperty(value="name") String name, @JsonProperty(value="patternType") PatternType patternType) {
        }

        @JsonProperty(value="resourceType")
        abstract ResourceType resourceType();

        @JsonProperty(value="name")
        abstract String name();

        @JsonProperty(value="patternType")
        abstract PatternType patternType();
    }

    @JsonStrict
    static abstract class AclBindingMixin {
        @JsonCreator
        AclBindingMixin(@JsonProperty(value="pattern") ResourcePattern resourcePattern, @JsonProperty(value="entry") AccessControlEntry entry) {
        }

        @JsonProperty(value="pattern")
        abstract ResourcePattern pattern();

        @JsonProperty(value="entry")
        abstract AccessControlEntry entry();
    }

    static class Utf8Converter
    extends StdConverter<byte[], String> {
        Utf8Converter() {
        }

        public String convert(byte[] value) {
            try {
                return new String(value, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }

    @JsonStrict
    static interface HeaderMixin {
        @JsonProperty(value="key")
        public String key();

        @JsonSerialize(converter=Utf8Converter.class)
        @JsonProperty(value="stringValue")
        public byte[] value();
    }

    @JsonStrict
    static abstract class ConsumerRecordMixin {
        ConsumerRecordMixin() {
        }

        @JsonProperty(value="topic")
        abstract String topic();

        @JsonProperty(value="partition")
        abstract int partition();

        @JsonProperty(value="headers")
        abstract Headers headers();

        @JsonProperty(value="key")
        abstract Object key();

        @JsonProperty(value="value")
        abstract Object value();

        @JsonProperty(value="offset")
        abstract long offset();

        @JsonProperty(value="timestamp")
        abstract long timestamp();

        @JsonProperty(value="timestampType")
        abstract TimestampType timestampType();
    }
}

