/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Inject;
import com.google.protobuf.Message;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.serializers.ProtoSerde;
import io.confluent.serializers.UberSerde;
import java.io.IOException;
import java.io.Writer;

public class ProtoJsonSerializerModule
extends SimpleModule {
    private final UberSerde<Alert.AlertInfo> alertInfoUberSerde;
    private final UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde;
    private final UberSerde<CommandAlert.MonitoringTriggerConfig> monitoringTriggerConfigUberSerde;
    private final UberSerde<CommandAlert.ActionConfig> actionConfigUberSerde;

    @Inject
    public ProtoJsonSerializerModule(UberSerde<Alert.AlertInfo> alertInfoUberSerde, UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde, UberSerde<CommandAlert.MonitoringTriggerConfig> monitoringTriggerConfigUberSerde, UberSerde<CommandAlert.ActionConfig> actionConfigUberSerde) {
        super("ProtoJsonSerializerModule", new Version(0, 1, 0, "alpha"));
        this.alertInfoUberSerde = alertInfoUberSerde;
        this.triggerMeasurementUberSerde = triggerMeasurementUberSerde;
        this.monitoringTriggerConfigUberSerde = monitoringTriggerConfigUberSerde;
        this.actionConfigUberSerde = actionConfigUberSerde;
        this.addSerializers();
    }

    protected void addSerializers() {
        this.addSerializer(Alert.AlertInfo.class, (JsonSerializer)new JsonSerializer<Alert.AlertInfo>(){

            public void serialize(Alert.AlertInfo value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ProtoJsonSerializerModule.this.alertInfoUberSerde.toJson((Object)value));
            }

            public Class<Alert.AlertInfo> handledType() {
                return Alert.AlertInfo.class;
            }
        });
        this.addSerializer(Controlcenter.TriggerMeasurement.class, (JsonSerializer)new JsonSerializer<Controlcenter.TriggerMeasurement>(){

            public void serialize(Controlcenter.TriggerMeasurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ProtoJsonSerializerModule.this.triggerMeasurementUberSerde.toJson((Object)value));
            }

            public Class<Controlcenter.TriggerMeasurement> handledType() {
                return Controlcenter.TriggerMeasurement.class;
            }
        });
        this.addSerializer(Command.CommandMessage.class, (JsonSerializer)new JsonSerializer<Command.CommandMessage>(){
            final ProtoSerde<Command.CommandMessage> commandMessageProtoSerde = new ProtoSerde((Message)Command.CommandMessage.getDefaultInstance());

            public void serialize(Command.CommandMessage value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(this.commandMessageProtoSerde.toJson((Message)value));
            }
        });
        this.addDeserializer(Command.CommandMessage.class, new UberJsonDeserializer(new ProtoSerde((Message)Command.CommandMessage.getDefaultInstance())));
        this.addSerializer(CommandAlert.MonitoringTriggerConfig.class, (JsonSerializer)new JsonSerializer<CommandAlert.MonitoringTriggerConfig>(){

            public void serialize(CommandAlert.MonitoringTriggerConfig value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ProtoJsonSerializerModule.this.monitoringTriggerConfigUberSerde.toJson((Object)value));
            }

            public Class<CommandAlert.MonitoringTriggerConfig> handledType() {
                return CommandAlert.MonitoringTriggerConfig.class;
            }
        });
        this.addDeserializer(CommandAlert.MonitoringTriggerConfig.class, new UberJsonDeserializer<CommandAlert.MonitoringTriggerConfig>(this.monitoringTriggerConfigUberSerde));
        this.addSerializer(CommandAlert.ActionConfig.class, (JsonSerializer)new JsonSerializer<CommandAlert.ActionConfig>(){

            public void serialize(CommandAlert.ActionConfig value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(ProtoJsonSerializerModule.this.actionConfigUberSerde.toJson((Object)value));
            }

            public Class<CommandAlert.ActionConfig> handledType() {
                return CommandAlert.ActionConfig.class;
            }
        });
        this.addDeserializer(CommandAlert.ActionConfig.class, new UberJsonDeserializer<CommandAlert.ActionConfig>(this.actionConfigUberSerde));
        this.addSerializer(Command.CommandKey.class, (JsonSerializer)new JsonSerializer<Command.CommandKey>(){
            private final UberSerde<Command.CommandKey> commandKeySerde = new ProtoSerde((Message)Command.CommandKey.getDefaultInstance());

            public void serialize(Command.CommandKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeRawValue(this.commandKeySerde.toJson((Object)value));
            }

            public Class<Command.CommandKey> handledType() {
                return Command.CommandKey.class;
            }
        });
    }

    static class UberJsonDeserializer<K>
    extends JsonDeserializer<K> {
        private final UberSerde<K> serde;

        UberJsonDeserializer(UberSerde<K> serde) {
            this.serde = serde;
        }

        public K deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            SegmentedStringWriter writer = new SegmentedStringWriter(new BufferRecycler());
            JsonGenerator generator = jsonParser.getCodec().getFactory().createGenerator((Writer)writer);
            generator.copyCurrentStructure(jsonParser);
            generator.close();
            return (K)this.serde.deserialize(this.serde.fromJson(writer.getAndClear()));
        }
    }
}

