/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import io.confluent.controlcenter.keys.Keys;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.Metric;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonStandard
public class DeliveryResponse {
    public String rollup;
    public DeliveryType type;
    public long startTimeMs;
    public long stepMs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String group;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String clientId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<Metric, ArrayList<Object>> produced = null;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<Metric, ArrayList<Object>> consumed = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<MemberResponse> members = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<MemberResponse> sources = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<MemberResponse> destinations = null;

    public DeliveryResponse(String rollup, long startTimeMs, long stepMs, String group, String clientId, DeliveryType deliveryType) {
        this.rollup = rollup;
        this.startTimeMs = startTimeMs;
        this.stepMs = stepMs;
        this.group = group;
        this.clientId = clientId;
        this.type = deliveryType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryResponse that = (DeliveryResponse)o;
        return Objects.equals(this.rollup, that.rollup) && Objects.equals(this.startTimeMs, that.startTimeMs) && Objects.equals(this.stepMs, that.stepMs) && Objects.equals(this.group, that.group) && Objects.equals(this.clientId, that.clientId) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rollup, this.startTimeMs, this.stepMs, this.group, this.clientId, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rollup", (Object)this.rollup).add("startTimeMs", this.startTimeMs).add("stepMs", this.stepMs).add("group", (Object)this.group).add("clientId", (Object)this.clientId).add("type", (Object)this.type).toString();
    }

    public List<MemberResponse> getMembers() {
        if (this.members == null) {
            return null;
        }
        Collections.sort(this.members);
        return this.members;
    }

    public List<MemberResponse> getSources() {
        if (this.sources == null) {
            return null;
        }
        Collections.sort(this.sources);
        return this.sources;
    }

    public List<MemberResponse> getDestinations() {
        if (this.destinations == null) {
            return null;
        }
        Collections.sort(this.destinations);
        return this.destinations;
    }

    @JsonStandard
    public static class MemberResponse
    implements Comparable<MemberResponse> {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String clientId;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String group;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String topic;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Integer partition;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<Metric, ArrayList<Object>> produced = Maps.newTreeMap();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public Map<Metric, ArrayList<Object>> consumed = Maps.newTreeMap();

        public MemberResponse(Controlcenter.MemberInfo memberInfo) {
            this.clientId = memberInfo.getClientId();
            this.group = memberInfo.getGroup();
            this.topic = Strings.emptyToNull((String)memberInfo.getTopicPartition().getTopic());
            if (this.topic != null) {
                this.partition = memberInfo.getTopicPartition().getPartition();
            } else {
                this.topic = Strings.emptyToNull((String)memberInfo.getTopic());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberResponse that = (MemberResponse)o;
            return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.group, that.group) && Objects.equals(this.topic, that.topic) && Objects.equals(this.partition, that.partition);
        }

        public int hashCode() {
            return Objects.hash(this.clientId, this.group, this.topic, this.partition);
        }

        @Override
        public int compareTo(MemberResponse o) {
            return ComparisonChain.start().compare((Comparable)((Object)Strings.nullToEmpty((String)this.clientId)), (Comparable)((Object)Strings.nullToEmpty((String)o.clientId))).compare((Comparable)((Object)Strings.nullToEmpty((String)this.group)), (Comparable)((Object)Strings.nullToEmpty((String)o.group))).compare((Comparable)((Object)Strings.nullToEmpty((String)this.topic)), (Comparable)((Object)Strings.nullToEmpty((String)o.topic))).compare(this.partition == null ? -1 : this.partition, o.partition == null ? -1 : o.partition).result();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("group", (Object)this.group).add("topic", (Object)this.topic).add("partition", (Object)this.partition).toString();
        }
    }

    public static enum DeliveryType {
        CONSUMER_GROUPS(Keys.KeyType.LOOKUP_CLIENTTYPE, Keys.KeyType.EXPECTED_PRODUCTION, Keys.KeyType.INFO_GROUPS_IN_CLIENTTYPE, Keys.KeyType.LOOKUP_CLIENTTYPE_GROUP, Keys.KeyType.EXPECTED_PRODUCTION_GROUP, Keys.KeyType.INFO_TOPICS_IN_CLIENTTYPE),
        CONSUMER_GROUP(Keys.KeyType.LOOKUP_CLIENTTYPE_GROUP, Keys.KeyType.EXPECTED_PRODUCTION_GROUP, Keys.KeyType.INFO_CLIENTIDS_IN_GROUP, Keys.KeyType.LOOKUP_CLIENTTYPE_CLIENT, Keys.KeyType.EXPECTED_PRODUCTION_CLIENT, Keys.KeyType.INFO_TOPICPARTITIONS_IN_GROUP),
        CONSUMER(Keys.KeyType.LOOKUP_CLIENTTYPE_CLIENT, Keys.KeyType.EXPECTED_PRODUCTION_CLIENT, Keys.KeyType.INFO_TOPICPARTITIONS_IN_CLIENT, Keys.KeyType.LOOKUP_CLIENTTYPE_CLIENT_TOPIC_PARTITION, Keys.KeyType.EXPECTED_PRODUCTION_IN_TOPICPARTITION_FOR_CLIENT, null),
        CONSUMER_GROUPS_TOPICS(Keys.KeyType.LOOKUP_CLIENTTYPE, Keys.KeyType.EXPECTED_PRODUCTION, Keys.KeyType.INFO_TOPICS_IN_CLIENTTYPE, Keys.KeyType.LOOKUP_CLIENTTYPE_TOPIC, Keys.KeyType.EXPECTED_PRODUCTION_IN_TOPIC, Keys.KeyType.INFO_GROUPS_IN_CLIENTTYPE),
        CONSUMER_GROUP_TOPICS(Keys.KeyType.LOOKUP_CLIENTTYPE_GROUP, Keys.KeyType.EXPECTED_PRODUCTION_GROUP, Keys.KeyType.INFO_TOPICPARTITIONS_IN_GROUP, Keys.KeyType.LOOKUP_CLIENTTYPE_GROUP_TOPICPARTITION, Keys.KeyType.EXPECTED_PRODUCTION_IN_TOPICPARTITION_FOR_GROUP, Keys.KeyType.INFO_CLIENTIDS_IN_GROUP);

        public final Keys.KeyType baseConsumptionKeyType;
        public final Keys.KeyType baseProductionKeyType;
        public final Keys.KeyType subGroupingKeyType;
        public final Keys.KeyType subConsumptionKeyType;
        public final Keys.KeyType subProductionKeyType;
        public final Keys.KeyType secondarySubGroupingKeyType;

        private DeliveryType(Keys.KeyType baseConsumptionKeyType, Keys.KeyType baseProductionKeyType, Keys.KeyType subGroupingKeyType, Keys.KeyType subConsumptionKeyType, Keys.KeyType subProductionKeyType, Keys.KeyType secondarySubGroupingKeyType) {
            this.baseConsumptionKeyType = baseConsumptionKeyType;
            this.baseProductionKeyType = baseProductionKeyType;
            this.subGroupingKeyType = subGroupingKeyType;
            this.subConsumptionKeyType = subConsumptionKeyType;
            this.subProductionKeyType = subProductionKeyType;
            this.secondarySubGroupingKeyType = secondarySubGroupingKeyType;
        }
    }
}

