/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import io.confluent.controlcenter.rest.res.OmgDeserializer;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.Collections;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmgRawDeserializer
extends OmgDeserializer {
    private static final Logger log = LoggerFactory.getLogger(OmgRawDeserializer.class);
    protected static final byte MAGIC_BYTE = 0;

    public OmgRawDeserializer(SchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    @Override
    protected Function<ConsumerRecord<byte[], byte[]>, Object> detectSchemaFormat(boolean isKey, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        Object payload = OmgRawDeserializer.fromSchemaFormat(selector, record);
        return payload != null ? r -> OmgRawDeserializer.fromSchemaFormat(selector, (ConsumerRecord<byte[], byte[]>)r) : null;
    }

    private static Object fromSchemaFormat(Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        byte[] bytes = selector.apply(record);
        if (bytes.length > 0 && bytes[0] == 0) {
            return Collections.singletonMap("__raw__", bytes);
        }
        return null;
    }
}

