/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import io.confluent.license.License;
import java.util.Objects;

@JsonStandard
public class UpdateLicenseResponse {
    @JsonProperty
    private final boolean updateSucceed;
    @JsonProperty
    private final CurrentLicense currentLicense;
    @JsonProperty
    private final String error;

    public UpdateLicenseResponse(boolean updateSucceed, CurrentLicense currentLicense, String error) {
        this.updateSucceed = updateSucceed;
        this.currentLicense = currentLicense;
        this.error = error;
    }

    public boolean isUpdateSucceed() {
        return this.updateSucceed;
    }

    public CurrentLicense getCurrentLicense() {
        return this.currentLicense;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateLicenseResponse that = (UpdateLicenseResponse)o;
        return Objects.equals(this.updateSucceed, that.updateSucceed) && Objects.equals(this.currentLicense, that.currentLicense) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.updateSucceed, this.currentLicense, this.error);
    }

    @JsonStandard
    public static class CurrentLicense {
        @JsonProperty
        private String audience;
        @JsonProperty
        private long expiration;
        @JsonProperty
        private String string;
        @JsonProperty
        private String licenseType;
        @JsonProperty(value="isCP4CC")
        private boolean isCP4CC;
        @JsonProperty
        private boolean inUse;

        public CurrentLicense(License license, boolean inUse) {
            this.audience = license.audience().isEmpty() ? null : (String)license.audience().get(0);
            this.expiration = license.expirationDate() != null ? license.expirationDate().getTime() : Long.MIN_VALUE;
            this.string = license.serializedForm();
            this.licenseType = license.type().toString();
            this.isCP4CC = license.deploymentScope().equals((Object)License.DeploymentScope.CP_FOR_CC);
            this.inUse = inUse;
        }

        public CurrentLicense build() {
            return this;
        }

        public String getAudience() {
            return this.audience;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public String getString() {
            return this.string;
        }

        public String getLicenseType() {
            return this.licenseType;
        }

        @JsonProperty(value="isCP4CC")
        public boolean isCP4CC() {
            return this.isCP4CC;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentLicense that = (CurrentLicense)o;
            return Objects.equals(this.audience, that.audience) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.string, that.string) && Objects.equals(this.licenseType, that.licenseType) && Objects.equals(this.isCP4CC, that.isCP4CC) && Objects.equals(this.inUse, that.inUse);
        }

        public int hashCode() {
            return Objects.hash(this.audience, this.expiration, this.string, this.licenseType, this.isCP4CC, this.inUse);
        }
    }
}

