/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rollup;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rollup {
    private static final Logger log = LoggerFactory.getLogger(Rollup.class);
    private final long millis;
    private final String name;
    private long retainMillis;

    Rollup(long millis, long retainMillis, String name) {
        this.millis = millis;
        this.retainMillis = retainMillis;
        this.name = name;
    }

    public static long window(long rollup, long unalignedWindow) {
        return unalignedWindow - unalignedWindow % rollup;
    }

    public String getName() {
        return this.name;
    }

    public long getMillis() {
        return this.millis;
    }

    public long getRetainMillis() {
        return this.retainMillis;
    }

    public void setRetainMillis(long retainMillis) {
        if (retainMillis <= this.millis) {
            throw new IllegalArgumentException("retainMillis must be greater than millis for rollup " + this.name + " millis=" + this.millis + " retainMillis=" + retainMillis);
        }
        this.retainMillis = retainMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rollup rollup = (Rollup)o;
        return this.millis == rollup.millis && this.retainMillis == rollup.retainMillis && Objects.equals(this.name, rollup.name);
    }

    public String toString() {
        return "Rollup{millis=" + this.millis + ", name='" + this.name + '\'' + ", retainMillis=" + this.retainMillis + '}';
    }

    public int hashCode() {
        return Objects.hash(this.millis, this.name, this.retainMillis);
    }

    public long getRetainSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.retainMillis);
    }

    public long toWindow(long unalignedWindow) {
        return Rollup.window(this.millis, unalignedWindow);
    }
}

