/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rollup;

import io.confluent.controlcenter.rollup.Rollup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RollupFactory {
    public static final String ONE_MINUTE = "ONE_MINUTE";
    public static final String THREE_HOURS = "THREE_HOURS";
    private static Rollup oneMinuteRollup;
    private static Rollup threeHourRollup;
    private static List<Rollup> allRollups;

    public static Rollup getOneMinuteRollup() {
        if (oneMinuteRollup == null) {
            throw new IllegalStateException("Rollups not initialized");
        }
        return oneMinuteRollup;
    }

    public static Rollup getThreeHourRollup() {
        if (threeHourRollup == null) {
            throw new IllegalStateException("Rollups not initialized");
        }
        return threeHourRollup;
    }

    public static List<Rollup> getAllRollups() {
        if (allRollups == null) {
            throw new IllegalStateException("Rollups not initialized");
        }
        return allRollups;
    }

    public static Rollup getRollupByName(String name) {
        if (ONE_MINUTE.equals(name)) {
            return oneMinuteRollup;
        }
        if (THREE_HOURS.equals(name)) {
            return threeHourRollup;
        }
        return null;
    }

    public static void initRollups(long oneMinuteRetainMillis, long threeHourRetainMillis) {
        if (oneMinuteRetainMillis < TimeUnit.MINUTES.toMillis(1L)) {
            throw new IllegalArgumentException("oneMinuteRetainMillis must be greater than 1 minute i.e. 60000");
        }
        if (threeHourRetainMillis < TimeUnit.HOURS.toMillis(3L)) {
            throw new IllegalArgumentException("threeHourRetainMillis must be greater than 3 hours i.e. 10800000");
        }
        oneMinuteRollup = new Rollup(TimeUnit.MINUTES.toMillis(1L), oneMinuteRetainMillis, ONE_MINUTE);
        threeHourRollup = new Rollup(TimeUnit.HOURS.toMillis(3L), threeHourRetainMillis, THREE_HOURS);
        allRollups = new ArrayList<Rollup>();
        allRollups.add(oneMinuteRollup);
        allRollups.add(threeHourRollup);
    }
}

