/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.base.Preconditions;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.rest.CompoundClusterTokenCredential;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;

public class SchemaRegistryClientManager
implements SchemaRegistryClientSupplier<CompoundClusterTokenCredential> {
    private final SchemaRegistryClusterMetadata srClusterMetadata;
    private final ControlCenterRbacConfig rbacConfig;
    private final Map<String, List<String>> srEndpointsLookup;
    private final Map<String, Map<String, Object>> srConfigsLookup;

    public SchemaRegistryClientManager(SchemaRegistryClusterMetadata srClusterMetadata, ControlCenterRbacConfig rbacConfig) {
        this.rbacConfig = rbacConfig;
        this.srClusterMetadata = srClusterMetadata;
        this.srEndpointsLookup = srClusterMetadata.getEndpoints();
        this.srConfigsLookup = srClusterMetadata.getConfigs();
    }

    @Override
    public SchemaRegistryClient getClient(CompoundClusterTokenCredential credential) {
        if (!this.srClusterMetadata.isSrEnabled().booleanValue()) {
            return null;
        }
        String srClusterId = credential.secondaryClusterId;
        if (Strings.isNullOrEmpty((String)srClusterId)) {
            srClusterId = this.getDefaultSrClusterId();
        }
        if (Strings.isNullOrEmpty((String)srClusterId)) {
            return null;
        }
        List<String> endpoints = this.srEndpointsLookup.get(srClusterId);
        if (endpoints == null || endpoints.isEmpty()) {
            return null;
        }
        return new CachedSchemaRegistryClient(endpoints, 100, Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider()), this.rbacConfig.isRbacEnabled() ? this.injectRbacImpersonationConfigs(this.srConfigsLookup.get(srClusterId), credential.token) : this.srConfigsLookup.get(srClusterId));
    }

    private Map<String, Object> injectRbacImpersonationConfigs(Map<String, Object> configs, String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0);
        this.rbacConfig.putAllRbacTokenConfigs(configs, token);
        configs.remove("basic.auth.credentials.source");
        configs.put("bearer.auth.credentials.source", "MDS");
        return configs;
    }

    private String getDefaultSrClusterId() {
        return this.srClusterMetadata.getClusters().isEmpty() ? null : ((SchemaRegistryCluster)this.srClusterMetadata.getClusters().get(0)).getClusterId();
    }
}

