/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization;

import com.google.protobuf.Message;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.verify.MonitoringVerifier;
import io.confluent.serializers.ProtoSerde;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringVerifierSerialization
implements Serializer<MonitoringVerifier>,
Deserializer<MonitoringVerifier> {
    private static final Logger log = LoggerFactory.getLogger(MonitoringVerifierSerialization.class);
    private final ProtoSerde<Controlcenter.VerifierInfo> serde = new ProtoSerde((Message)Controlcenter.VerifierInfo.getDefaultInstance());

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.serde.configure(configs, isKey);
    }

    public byte[] serialize(String topic, MonitoringVerifier data) {
        Controlcenter.VerifierInfo info = this.toVerifierInfo(data);
        if (info == null) {
            return null;
        }
        return this.serde.serialize(topic, (Message)info);
    }

    public MonitoringVerifier deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        Controlcenter.VerifierInfo info = (Controlcenter.VerifierInfo)this.serde.deserialize(topic, data);
        MonitoringVerifier out = null;
        if (info != null) {
            try {
                out = new MonitoringVerifier(info);
            }
            catch (Exception e) {
                log.error("Constructing monitoring verifier from de-serialized verifier info", (Throwable)e);
            }
        }
        return out;
    }

    private Controlcenter.VerifierInfo toVerifierInfo(MonitoringVerifier verifier) {
        if (verifier == null) {
            return null;
        }
        return verifier.createVerifierInfo();
    }

    public byte[] fromJson(String json) {
        return this.serde.fromJson(json);
    }

    public String toJson(MonitoringVerifier data) {
        return this.serde.toJson((Message)this.toVerifierInfo(data));
    }

    public void close() {
        this.serde.close();
    }
}

