/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.servicehealthcheck;

import com.google.common.collect.ImmutableMap;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.servicehealthcheck.ArmeriaServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.controlcenter.ssl.SslHolder;
import io.confluent.rest.RestConfig;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ArmeriaSingleServiceHealthCheck
implements SingleServiceHealthCheck {
    private static final String CLUSTER_KEY = "";
    private final ServiceHealthCheck serviceHealthCheck;

    public ArmeriaSingleServiceHealthCheck(Duration healthCheckInterval, List<String> urls, String healthCheckPath, RestConfig restConfig, ControlCenterConfig controlCenterConfig, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, Function<String, HttpCredential> credentialSupplier) {
        this.serviceHealthCheck = new ArmeriaServiceHealthCheck(healthCheckInterval, (Map<String, List<String>>)ImmutableMap.of((Object)CLUSTER_KEY, urls), healthCheckPath, restConfig, controlCenterConfig, serverSslHolder, proxySslHolders, credentialSupplier);
    }

    @Override
    public List<String> getHealthyUrls() {
        return this.serviceHealthCheck.getHealthyUrls(CLUSTER_KEY);
    }

    @Override
    public List<String> getOriginalUrls() {
        return this.serviceHealthCheck.getOriginalUrls(CLUSTER_KEY);
    }

    @Override
    public void markUnhealthy(String url) {
        this.serviceHealthCheck.markUnhealthy(CLUSTER_KEY, url);
    }

    @Override
    public void close() {
        this.serviceHealthCheck.close();
    }
}

