/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.servicehealthcheck;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.connect.ConnectClusterMetadata;
import io.confluent.controlcenter.httpclient.BasicHttpCredential;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.servicehealthcheck.ArmeriaServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ArmeriaSingleServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.controlcenter.ssl.SslHolder;
import io.confluent.rest.RestConfig;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ServiceHealthCheckModule
extends AbstractModule {
    @Provides
    @Singleton
    @Nullable
    @Inject
    @RbacServiceHealthCheckCredential
    public HttpCredential getRbacServiceHealthCheckCredential(ControlCenterRbacConfig rbacConfig) {
        if (rbacConfig.isRbacEnabled()) {
            return new BasicHttpCredential(rbacConfig.getControlCenterUsername(), rbacConfig.getControlCenterPassword());
        }
        return null;
    }

    @Provides
    @Singleton
    @Inject
    @KsqlHealthCheckCredential
    public Function<String, HttpCredential> getKsqlHealthCheckCredential(@Nullable @RbacServiceHealthCheckCredential HttpCredential rbacCredential, KsqlClusterMetadata ksqlClusterMetadata) {
        Map<String, HttpCredential> basicAuthCredentials = ksqlClusterMetadata.getCredentials();
        return this.credentialFunctionSupplier(rbacCredential, basicAuthCredentials);
    }

    @Provides
    @Singleton
    @Inject
    @KsqlHealthCheck
    public ServiceHealthCheck getKsqlServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, KsqlClusterMetadata ksqlClusterMetadata, RestConfig restConfig, ControlCenterConfig controlCenterConfig, @ControlCenterConfigModule.ServerSslHolder SslHolder serverSslHolder, List<SslHolder> proxySslHolders, @KsqlHealthCheckCredential Function<String, HttpCredential> credentialSupplier) {
        return new ArmeriaServiceHealthCheck(healthCheckInterval, ksqlClusterMetadata.getClusters().stream().collect(Collectors.toMap(KsqlCluster::getClusterId, KsqlCluster::getEndpoints)), "/info", restConfig, controlCenterConfig, serverSslHolder, proxySslHolders, credentialSupplier);
    }

    @Provides
    @Singleton
    @Inject
    @ConnectHealthCheckCredential
    public Function<String, HttpCredential> getConnectHealthCheckCredential(@Nullable @RbacServiceHealthCheckCredential HttpCredential rbacCredential, ConnectClusterMetadata connectClusterMetadata) {
        Map<String, HttpCredential> basicAuthCredentials = connectClusterMetadata.getCredentials();
        return this.credentialFunctionSupplier(rbacCredential, basicAuthCredentials);
    }

    @Provides
    @Singleton
    @Inject
    @ConnectHealthCheck
    public ServiceHealthCheck getConnectServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, ConnectClusterMetadata connectClusterMetadata, RestConfig restConfig, ControlCenterConfig controlCenterConfig, @ControlCenterConfigModule.ServerSslHolder SslHolder serverSslHolder, List<SslHolder> proxySslHolders, @ConnectHealthCheckCredential Function<String, HttpCredential> credentialSupplier) {
        return new ArmeriaServiceHealthCheck(healthCheckInterval, connectClusterMetadata.getEndpoints(), controlCenterConfig.getString("confluent.controlcenter.connect.healthcheck.endpoint"), restConfig, controlCenterConfig, serverSslHolder, proxySslHolders, credentialSupplier);
    }

    @Provides
    @Singleton
    @Inject
    @SchemaRegistryHealthCheckCredential
    public Function<String, HttpCredential> getSchemaRegistryHealthCheckCredential(@Nullable @RbacServiceHealthCheckCredential HttpCredential rbacCredential, SchemaRegistryClusterMetadata srClusterMetadata) {
        Map<String, HttpCredential> basicAuthCredentials = srClusterMetadata.getCredentials();
        return this.credentialFunctionSupplier(rbacCredential, basicAuthCredentials);
    }

    @Provides
    @Singleton
    @Inject
    @SchemaRegistryHealthCheck
    public ServiceHealthCheck getSchemaRegistryServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, SchemaRegistryClusterMetadata schemaRegistryClusterMetadata, RestConfig restConfig, ControlCenterConfig controlCenterConfig, @ControlCenterConfigModule.ServerSslHolder SslHolder serverSslHolder, List<SslHolder> proxySslHolders, @SchemaRegistryHealthCheckCredential Function<String, HttpCredential> credentialSupplier) {
        return new ArmeriaServiceHealthCheck(healthCheckInterval, schemaRegistryClusterMetadata.getEndpoints(), "/", restConfig, controlCenterConfig, serverSslHolder, proxySslHolders, credentialSupplier);
    }

    @Provides
    @Singleton
    @Inject
    @MetadataServiceHealthCheck
    public SingleServiceHealthCheck getMetadataServiceHealthCheck(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, ControlCenterRbacConfig controlCenterRbacConfig, RestConfig restConfig, ControlCenterConfig controlCenterConfig, @ControlCenterConfigModule.ServerSslHolder SslHolder serverSslHolder, List<SslHolder> proxySslHolders, @Nullable @RbacServiceHealthCheckCredential HttpCredential credential) {
        return new ArmeriaSingleServiceHealthCheck(healthCheckInterval, controlCenterRbacConfig.getMetadataServiceUrls(), "/security/1.0/metadataClusterId", restConfig, controlCenterConfig, serverSslHolder, proxySslHolders, whatever -> credential);
    }

    @Provides
    @Inject
    @KafkaRestServiceHealthCheck
    public Function<List<String>, SingleServiceHealthCheck> getSimpleHealthCheckSupplier(@ControlCenterConfigModule.ServiceHealthCheckInterval Duration healthCheckInterval, RestConfig restConfig, ControlCenterConfig controlCenterConfig, @ControlCenterConfigModule.ServerSslHolder SslHolder serverSslHolder, List<SslHolder> proxySslHolders, @Nullable @RbacServiceHealthCheckCredential HttpCredential credential) {
        return urls -> new ArmeriaSingleServiceHealthCheck(healthCheckInterval, (List<String>)urls, "/v1/metadata/id", restConfig, controlCenterConfig, serverSslHolder, proxySslHolders, whatever -> credential);
    }

    private Function<String, HttpCredential> credentialFunctionSupplier(HttpCredential rbacCredential, Map<String, HttpCredential> basicAuthCredentials) {
        if (rbacCredential != null) {
            return clusterNameOrId -> rbacCredential;
        }
        return clusterNameOrId -> basicAuthCredentials.getOrDefault(clusterNameOrId, null);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KafkaRestServiceHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MetadataServiceHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SchemaRegistryHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SchemaRegistryHealthCheckCredential {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConnectHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConnectHealthCheckCredential {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KsqlHealthCheck {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KsqlHealthCheckCredential {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface RbacServiceHealthCheckCredential {
    }
}

