/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.ssl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ssl.SslHolder;
import io.confluent.rest.RestConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import nl.altindag.ssl.SSLFactory;
import org.apache.commons.collections.MapUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslUtils {
    @VisibleForTesting
    public static SSLFactory buildSslFactory(String protocol, @Nullable String secureRandomAlgorithm, @Nullable String provider, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, ControlCenterConfig controlCenterConfig) {
        Preconditions.checkNotNull((Object)protocol);
        Preconditions.checkNotNull((Object)serverSslHolder);
        Preconditions.checkNotNull(proxySslHolders);
        Preconditions.checkNotNull((Object)((Object)controlCenterConfig));
        SecureRandom secureRandom = SslUtils.getSecureRandomInstance(secureRandomAlgorithm, provider);
        boolean useJvmTruststore = controlCenterConfig.getBoolean("confluent.controlcenter.use.default.jvm.truststore");
        boolean useOsTruststore = controlCenterConfig.getBoolean("confluent.controlcenter.use.default.os.truststore");
        return SslUtils.buildSslFactory(protocol, secureRandom, serverSslHolder, proxySslHolders, useJvmTruststore, useOsTruststore);
    }

    private static SSLFactory buildSslFactory(String protocol, @Nullable SecureRandom secureRandom, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, boolean useJvmTruststore, boolean useOsTruststore) {
        List proxyKmfs = proxySslHolders.stream().map(SslHolder::getKeyManagerFactory).filter(Objects::nonNull).collect(Collectors.toList());
        List<TrustManagerFactory> proxyTmfs = proxySslHolders.stream().map(SslHolder::getTrustManagerFactory).filter(Objects::nonNull).collect(Collectors.toList());
        if (proxyKmfs.isEmpty() && proxyTmfs.isEmpty() && !useJvmTruststore && !useOsTruststore) {
            return null;
        }
        SSLFactory.Builder builder = SSLFactory.builder().withSslContextAlgorithm(protocol);
        SslUtils.setIfNotNull(serverSslHolder.getKeyManagerFactory(), arg_0 -> ((SSLFactory.Builder)builder).withIdentityMaterial(arg_0));
        for (SslHolder sslHolder : proxySslHolders) {
            SslUtils.setIfNotNull(sslHolder.getKeyManagerFactory(), arg_0 -> ((SSLFactory.Builder)builder).withIdentityMaterial(arg_0));
            Map<String, List<String>> clientIdentityRoute = sslHolder.getClientAliasesToHosts();
            if (MapUtils.isEmpty(clientIdentityRoute)) continue;
            builder.withClientIdentityRoute(clientIdentityRoute);
        }
        SslUtils.setIfNotNull(serverSslHolder.getTrustManagerFactory(), arg_0 -> ((SSLFactory.Builder)builder).withTrustMaterial(arg_0));
        proxyTmfs.forEach(arg_0 -> ((SSLFactory.Builder)builder).withTrustMaterial(arg_0));
        SslUtils.setIfNotNull(secureRandom, arg_0 -> ((SSLFactory.Builder)builder).withSecureRandom(arg_0));
        if (useJvmTruststore) {
            builder.withDefaultTrustMaterial();
        }
        if (useOsTruststore) {
            builder.withSystemTrustMaterial();
        }
        return builder.build();
    }

    @Nullable
    private static SecureRandom getSecureRandomInstance(String algorithm, String provider) {
        if (algorithm != null) {
            try {
                if (provider != null) {
                    return SecureRandom.getInstance(algorithm, provider);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                return SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T> void setIfNotNull(T element, Consumer<T> consumer) {
        if (element != null) {
            consumer.accept(element);
        }
    }

    public static class JettySslUtils {
        public static void buildJettySslContext(SslContextFactory sslContextFactory, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, ControlCenterConfig controlCenterConfig) {
            SSLFactory sslFactory = JettySslUtils.buildJettySslFactory(sslContextFactory, serverSslHolder, proxySslHolders, controlCenterConfig);
            if (sslFactory != null) {
                sslContextFactory.setSslContext(sslFactory.getSslContext());
            }
        }

        private static SSLFactory buildJettySslFactory(SslContextFactory sslContextFactory, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, ControlCenterConfig controlCenterConfig) {
            return SslUtils.buildSslFactory(sslContextFactory.getProtocol(), sslContextFactory.getSecureRandomAlgorithm(), sslContextFactory.getProvider(), serverSslHolder, proxySslHolders, controlCenterConfig);
        }
    }

    public static class NettySslUtils {
        public static void buildNettySslContext(SslContextBuilder sslContextBuilder, RestConfig restConfig, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, ControlCenterConfig controlCenterConfig) {
            NettySslUtils.setSslParameters(sslContextBuilder, restConfig);
            SSLFactory sslFactory = NettySslUtils.buildNettySslFactory(restConfig, serverSslHolder, proxySslHolders, controlCenterConfig);
            if (sslFactory != null) {
                sslFactory.getKeyManager().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).keyManager(arg_0));
                sslFactory.getTrustManager().ifPresent(arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
            } else {
                SslUtils.setIfNotNull(serverSslHolder.getKeyManagerFactory(), arg_0 -> ((SslContextBuilder)sslContextBuilder).keyManager(arg_0));
                SslUtils.setIfNotNull(serverSslHolder.getTrustManagerFactory(), arg_0 -> ((SslContextBuilder)sslContextBuilder).trustManager(arg_0));
            }
        }

        private static void setSslParameters(SslContextBuilder sslContextBuilder, RestConfig restConfig) {
            List enabledProtocols = restConfig.getList("ssl.enabled.protocols");
            if (!enabledProtocols.isEmpty()) {
                sslContextBuilder.protocols((Iterable)enabledProtocols);
            }
            ClientAuth clientAuth = ClientAuth.NONE;
            String clientAuthString = restConfig.getString("ssl.client.authentication");
            if (clientAuthString.equals("REQUESTED")) {
                clientAuth = ClientAuth.OPTIONAL;
            } else if (clientAuthString.equals("REQUIRED")) {
                clientAuth = ClientAuth.REQUIRE;
            }
            sslContextBuilder.clientAuth(clientAuth);
            List cipherSuites = restConfig.getList("ssl.cipher.suites");
            if (!cipherSuites.isEmpty()) {
                sslContextBuilder.ciphers((Iterable)cipherSuites);
            }
        }

        private static SSLFactory buildNettySslFactory(RestConfig restConfig, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, ControlCenterConfig controlCenterConfig) {
            return SslUtils.buildSslFactory(restConfig.getString("ssl.protocol"), null, restConfig.getString("ssl.provider"), serverSslHolder, proxySslHolders, controlCenterConfig);
        }
    }
}

