/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.util.LruSet;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClusterMetadataToCommandMapper
implements KeyValueMapper<Void, CommandClusterMetadata.KafkaClusterMetadata, KeyValue<Command.CommandKey, Command.CommandMessage>> {
    private static final Logger log = LoggerFactory.getLogger(KafkaClusterMetadataToCommandMapper.class);
    private final LruSet<CommandClusterMetadata.KafkaClusterMetadata> clusters;
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore;

    @Inject
    public KafkaClusterMetadataToCommandMapper(LruSet<CommandClusterMetadata.KafkaClusterMetadata> clusters, @CommandModule.ClusterMetadataStore Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore) {
        this.clusters = clusters;
        this.clusterMetadataStore = clusterMetadataStore;
    }

    public KeyValue<Command.CommandKey, Command.CommandMessage> apply(Void unused, CommandClusterMetadata.KafkaClusterMetadata cluster) {
        log.trace("mapping cluster={}", (Object)cluster.getClusterId());
        if (this.clusters.add(cluster)) {
            Command.CommandKey key = Command.CommandKey.newBuilder().setConfigType(Command.CommandConfigType.CLUSTER_METADATA).setGuid(cluster.getClusterId()).build();
            log.trace("checking if cluster={} already exists", (Object)cluster.getClusterId());
            if (((ReadOnlyKeyValueStore)this.clusterMetadataStore.get()).get((Object)key) == null) {
                Command.CommandMessage clusterData = Command.CommandMessage.newBuilder().setClusterMetadata(CommandClusterMetadata.ClusterMetadata.newBuilder().setKafka(cluster).build()).build();
                log.debug("adding cluster={}", (Object)clusterData);
                return KeyValue.pair((Object)key, (Object)clusterData);
            }
        } else {
            log.trace("skipping cluster={}", (Object)cluster.getClusterId());
        }
        return KeyValue.pair(null, null);
    }
}

