/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rollup.Rollup;
import io.confluent.controlcenter.rollup.RollupFactory;
import io.confluent.controlcenter.serialization.WindowStoreSerde;
import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.UberSerde;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;

public class TopicStoreMaster {
    private final String streamsAppId;
    private final Topic<Void, Monitoring.MonitoringMessage, Void, Void> monitoringTopic;
    private final Topic<Void, ConfluentMetric.MetricsMessage, Void, Void> metricsTopic;
    private final Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic;
    private final Map<String, Topic> topicMap = new HashMap<String, Topic>();
    private final Map<String, Store> storeMap = new HashMap<String, Store>();
    private final Map<String, Store> windowedStoreMap = new HashMap<String, Store>();
    private final Set<String> createTimeTopics = new HashSet<String>();
    private final Set<String> lruStores = new HashSet<String>();
    private final Set<String> lruStoreTopicNames = new HashSet<String>();

    @Inject
    public TopicStoreMaster(@ControlCenterModule.StreamsAppId String streamsAppId, @Nullable @ControlCenterModule.MonitoringTopic Topic<Void, Monitoring.MonitoringMessage, Void, Void> monitoringTopic, @Nullable @ControlCenterModule.MetricsTopic Topic<Void, ConfluentMetric.MetricsMessage, Void, Void> metricsTopic, @CommandModule.CommandTopic Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic, @ControlCenterModule.AllTopics ImmutableSet<Topic> topics, @ControlCenterModule.AllStores ImmutableSet<Store> stores, @ControlCenterModule.CreateTime ImmutableSet<Topic> createTimeTopics, @ControlCenterModule.VerifiableStores Set<Store<String, Controlcenter.VerifiableMonitoringMessage, Long>> verifiableStores) {
        this.streamsAppId = streamsAppId;
        this.monitoringTopic = monitoringTopic;
        this.metricsTopic = metricsTopic;
        this.commandTopic = commandTopic;
        for (Store<String, Controlcenter.VerifiableMonitoringMessage, Long> store : verifiableStores) {
            this.lruStores.add(store.name);
        }
        for (Topic topic : topics) {
            this.registerTopic(topic);
        }
        for (Store store : stores) {
            this.registerStore(store);
        }
        for (Topic topic : createTimeTopics) {
            this.createTimeTopics.add(topic.name);
        }
    }

    private void registerTopic(Topic topic) {
        if (topic.rollup) {
            for (Rollup rollup : RollupFactory.getAllRollups()) {
                this.registerTopic(TopicStoreMaster.nameJoin(topic.name, rollup.getName()), topic);
            }
        } else {
            this.registerTopic(topic.name, topic);
        }
        if (topic.store != null) {
            this.registerStore(topic.store);
        }
    }

    private void registerTopic(String name, Topic topic) {
        this.topicMap.put(name, topic);
    }

    private void registerStore(Store store) {
        String prefixedName = TopicStoreMaster.nameJoin(this.streamsAppId, store.name);
        if (store.rollup) {
            for (Rollup rollup : RollupFactory.getAllRollups()) {
                this.registerStore(TopicStoreMaster.nameJoin(prefixedName, rollup.getName()), store);
            }
        } else {
            this.registerStore(prefixedName, store);
        }
    }

    private void registerStore(String prefixedName, Store store) {
        this.registerStore(prefixedName, "changelog", store);
        this.registerStore(prefixedName, "repartition", store);
    }

    private void registerStore(String prefixedName, String suffix, Store store) {
        String topicName = TopicStoreMaster.nameJoin(prefixedName, suffix);
        if (!this.topicMap.containsKey(topicName)) {
            if (store.windowedSerde != null) {
                this.windowedStoreMap.put(topicName, store);
            } else {
                this.storeMap.put(topicName, store);
            }
            if (this.lruStores.contains(store.name)) {
                this.lruStoreTopicNames.add(topicName);
            }
        }
    }

    public static String nameJoin(String ... parts) {
        return Joiner.on((String)"-").join((Object[])parts);
    }

    public static <K, V, T> Store<K, V, T> storeForRollup(Store<K, V, T> baseStore, Rollup rollup) {
        return new Store(TopicStoreMaster.nameJoin(baseStore.name, rollup.getName()), baseStore.keySerde, baseStore.valueSerde, baseStore.aggregateSerde, baseStore.windowedSerde, baseStore.rollup);
    }

    public static <K, V, K1, V1> Topic<K, V, K1, V1> topicForRollup(Topic<K, V, K1, V1> baseTopic, Rollup rollup) {
        return new Topic(TopicStoreMaster.nameJoin(baseTopic.name, rollup.getName()), TopicStoreMaster.storeForRollup(baseTopic.store, rollup), baseTopic.keySerde, baseTopic.valueSerde, baseTopic.rollup);
    }

    public ImmutableSet<String> getInputTopicNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.monitoringTopic != null) {
            builder.add((Object)this.monitoringTopic.name);
        }
        if (this.metricsTopic != null) {
            builder.add((Object)this.metricsTopic.name);
        }
        builder.add((Object)this.commandTopic.name);
        return builder.build();
    }

    public String getMonitoringTopicName() {
        Preconditions.checkNotNull(this.monitoringTopic, (Object)"accessing monitoring topic in management mode");
        return this.monitoringTopic.name;
    }

    public String getMetricsTopicName() {
        Preconditions.checkNotNull(this.metricsTopic, (Object)"accessing metrics topic in management mode");
        return this.metricsTopic.name;
    }

    public ImmutableSet<String> getIntermediateTopicNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.topicMap.keySet());
        names.removeAll((Collection<?>)this.getInputTopicNames());
        return ImmutableSet.copyOf(names);
    }

    public ImmutableSet<String> getLogAppendTimeIntermediateTopicNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.topicMap.keySet());
        names.removeAll((Collection<?>)this.getInputTopicNames());
        names.removeAll(this.createTimeTopics);
        return ImmutableSet.copyOf(names);
    }

    public ImmutableSet<String> getPersistentStoreTopicNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.storeMap.keySet());
        names.removeAll(this.lruStoreTopicNames);
        return ImmutableSet.copyOf(names);
    }

    public ImmutableSet<String> getWindowedStoreTopicNames() {
        return ImmutableSet.builder().addAll(this.windowedStoreMap.keySet()).build();
    }

    public ImmutableSet<String> getLruStoreTopicNames() {
        return ImmutableSet.copyOf(this.lruStoreTopicNames);
    }

    public ImmutableSet<String> getInternalTopicNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.getIntermediateTopicNames());
        builder.addAll(this.getPersistentStoreTopicNames());
        builder.addAll(this.getLruStoreTopicNames());
        builder.addAll(this.getWindowedStoreTopicNames());
        return builder.build();
    }

    public SerdePair getSerdesForTopic(String topicName) {
        if (topicName.endsWith("-changelog")) {
            if (this.storeMap.containsKey(topicName)) {
                Store store = this.storeMap.get(topicName);
                return new SerdePair(store.keySerde, store.aggregateSerde, store.windowedSerde);
            }
            if (this.windowedStoreMap.containsKey(topicName)) {
                Store store = this.windowedStoreMap.get(topicName);
                return new SerdePair(store.keySerde, store.aggregateSerde, store.windowedSerde);
            }
        }
        if (this.topicMap.containsKey(topicName)) {
            Topic topic = this.topicMap.get(topicName);
            return new SerdePair(topic.keySerde, topic.valueSerde);
        }
        return null;
    }

    public Topic getTopic(String topicName) {
        return this.topicMap.get(topicName);
    }

    public static String getInternalTopicName(String streamsAppId, String topic) {
        return TopicStoreMaster.nameJoin(streamsAppId, topic);
    }

    public static class Store<K, V, T> {
        public String name;
        public boolean rollup;
        public UberSerde<K> keySerde;
        public UberSerde<V> valueSerde;
        public UberSerde<T> aggregateSerde;
        public WindowStoreSerde windowedSerde;
        public QueryableStoreType<ReadOnlyKeyValueStore<K, V>> queryableKeyValueStoreType;
        public QueryableStoreType<ReadOnlyWindowStore<K, V>> queryableWindowStoreType;

        public Store(String name, UberSerde<K> keySerde, UberSerde<V> valueSerde, UberSerde<T> aggregateSerde, boolean rollup) {
            this(name, keySerde, valueSerde, aggregateSerde, null, rollup);
        }

        Store(String name, UberSerde<K> keySerde, UberSerde<V> valueSerde, UberSerde<T> aggregateSerde, WindowStoreSerde windowedSerde, boolean rollup) {
            this.name = name;
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.aggregateSerde = aggregateSerde;
            this.windowedSerde = windowedSerde;
            this.rollup = rollup;
            if (windowedSerde == null) {
                this.queryableKeyValueStoreType = QueryableStoreTypes.keyValueStore();
            } else {
                this.queryableWindowStoreType = QueryableStoreTypes.windowStore();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("rollup", this.rollup).toString();
        }
    }

    public static class Topic<K, V, K1, V1> {
        public String name;
        public Store<K1, V, V1> store;
        public UberSerde<K> keySerde;
        public UberSerde<V> valueSerde;
        public boolean rollup;

        public Topic(String name, Store<K1, V, V1> store, UberSerde<K> keySerde, UberSerde<V> valueSerde, boolean rollup) {
            this.name = name;
            this.store = store;
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.rollup = rollup;
        }
    }

    public static class SerdePair {
        public UberSerde keySerde;
        public UberSerde valueSerde;
        public WindowStoreSerde windowedSerde;

        SerdePair(UberSerde keySerde, UberSerde valueSerde) {
            this(keySerde, valueSerde, null);
        }

        SerdePair(UberSerde keySerde, UberSerde valueSerde, WindowStoreSerde windowedSerde) {
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.windowedSerde = windowedSerde;
        }
    }
}

