/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provides;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.keys.Keys;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.serialization.OrderedKeyPrefixedSerdeSupplier;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.serialization.WindowStoreSerde;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import io.confluent.controlcenter.streams.verify.MonitoringVerifier;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.OrderedKeyUberSerde;
import io.confluent.serializers.UberSerde;
import io.confluent.serializers.UberSerdes;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicStoreModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(TopicStoreModule.class);
    private static final String VERIFIER_STORE_NAME = "MonitoringVerifierStore";
    private static final String GROUP_STORE_NAME = "Group";
    private static final String CONSUMER_GROUP_AGGREGATE_TP_STORE = "aggregate-topic-partition-store";
    private static final String CONSUMER_GROUP_GROUP_AGGREGATE_STORE = "group-aggregate-store";
    private static final String MONITORING_MESSAGE_REKEY_STORE = "monitoring-message-rekey-store";
    private static final String MONITORING_MESSAGE_EXTENSION_STORE = "monitoring-aggregate-rekey-store";
    private static final String MONITORING_STREAM_STORE_NAME = "MonitoringStream";
    private static final String MONITORING_AGGREGATOR_WINDOWS_STORE_NAME = "MonitoringMessageAggregatorWindows";
    private static final String METRICS_AGGREGATE_STORE = "MetricsAggregateStore";
    private static final String METRICS_AGGREGATE_REPARTITION_TOPIC = "MetricsAggregateStore-repartition";
    private static final String AGG_TOPIC_PARTITION_TABLE_WINDOWS_STORE_NAME = "aggregatedTopicPartitionTableWindows";
    private static final String MONITORING_TRIGGER_STORE_NAME = "MonitoringTriggerStore";
    private static final String TRIGGER_ACTIONS_STORE_NAME = "TriggerActionsStore";
    private static final String TRIGGER_EVENTS_STORE_NAME = "TriggerEventsStore";
    private static final String ALERT_HISTORY_STORE_NAME = "AlertHistoryStore";
    static final String KSTREAM_OUTEROTHER = "KSTREAM-OUTEROTHER-0000000106-store";
    static final String KSTREAM_OUTERTHIS = "KSTREAM-OUTERTHIS-0000000105-store";
    private static final String GROUP_STREAM_EXTENSION_TOPIC = "group-stream-extension-rekey";
    private static final String CLUSTER_STREAM_EXTENSION_TOPIC = "cluster-rekey";
    private static final String MONITORING_TRIGGER_EVENT_REKEY_TOPIC = "monitoring-trigger-event-rekey";
    private static final String METRICS_TRIGGER_MEASUREMENT_TOPIC = "metrics-trigger-measurement-rekey";
    private static final String EXPECTED_GROUP_CONSUMPTION_AGGREGATE_TOPIC = "expected-group-consumption-rekey";
    private static final String ACTUAL_GROUP_CONSUMPTION_AGGREGATE_TOPIC = "actual-group-consumption-rekey";
    public static final Set<String> INTERMEDIATE_TOPICS_SUFFIX = ImmutableSet.of((Object)"actual-group-consumption-rekey", (Object)"monitoring-trigger-event-rekey", (Object)"MetricsAggregateStore-repartition", (Object)"expected-group-consumption-rekey", (Object)"monitoring-message-rekey-store", (Object)"metrics-trigger-measurement-rekey", (Object[])new String[]{"group-stream-extension-rekey", "cluster-rekey"});

    protected void configure() {
    }

    @Provides
    @Inject
    @MetricsAggregateRepartitionTopic
    protected TopicStoreMaster.Topic<?, MetricHolder, Void, Void> getMetricsAggregateRepartitionTopic(@ControlCenterModule.StreamsAppId String streamsAppId, UberSerde<ByteBuffer> byteBufferSerde, UberSerde<MetricHolder> metricValuesSerde) {
        return new TopicStoreMaster.Topic(TopicStoreMaster.getInternalTopicName(streamsAppId, METRICS_AGGREGATE_REPARTITION_TOPIC), null, byteBufferSerde, metricValuesSerde, false);
    }

    @Provides
    @Inject
    @ReKeyedMonitoringTopic
    protected TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void> getRekeyedMonitoringTopic(@ControlCenterModule.StreamsAppId String streamsAppId, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde) {
        return new TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void>(TopicStoreMaster.getInternalTopicName(streamsAppId, MONITORING_MESSAGE_REKEY_STORE), null, null, monitoringMessageSerde, false);
    }

    @Provides
    @Inject
    @ReKeyedTriggerEventTopic
    protected TopicStoreMaster.Topic<Bytes, Controlcenter.TriggerEvent, Void, Void> getRekeyedTriggerEventTopic(@ControlCenterModule.StreamsAppId String streamsAppId, @SerializationModule.MonitoringTriggerKeySerde OrderedKeyUberSerde<Controlcenter.WindowedClusterGroup> keySerde, UberSerde<Controlcenter.TriggerEvent> triggerEventSerde) {
        return new TopicStoreMaster.Topic(TopicStoreMaster.getInternalTopicName(streamsAppId, MONITORING_TRIGGER_EVENT_REKEY_TOPIC), null, (UberSerde<Controlcenter.WindowedClusterGroup>)keySerde, triggerEventSerde, false);
    }

    @Provides
    @Inject
    @MonitoringMsgExtensionStore
    protected TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> getMonitoringMessageExtensionTopic(UberSerde<String> stringSerde, UberSerde<Controlcenter.VerifiableMonitoringMessage> verifiableMonitoringMessageUberSerde) {
        boolean rollup = false;
        return new TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long>(MONITORING_MESSAGE_EXTENSION_STORE, stringSerde, verifiableMonitoringMessageUberSerde, UberSerdes.longs(), rollup);
    }

    @Provides
    @Inject
    @GroupStreamExtensionTopic
    protected TopicStoreMaster.Topic<Bytes, Controlcenter.WindowedGrouping, Void, Controlcenter.WindowedGrouping> getGroupStreamExtensionTopic(@ControlCenterModule.StreamsAppId String streamsAppId, OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Controlcenter.WindowedGrouping> windowedGroupingUberSerde) {
        boolean rollup = false;
        return new TopicStoreMaster.Topic<Bytes, Controlcenter.WindowedGrouping, Void, Controlcenter.WindowedGrouping>(TopicStoreMaster.getInternalTopicName(streamsAppId, GROUP_STREAM_EXTENSION_TOPIC), null, (UberSerde<Bytes>)keySerdeSupplier.get(), windowedGroupingUberSerde, rollup);
    }

    @Provides
    @Inject
    @ClusterStreamExtensionTopic
    protected TopicStoreMaster.Topic<Bytes, Controlcenter.Cluster, Void, Controlcenter.Cluster> getClusterStreamExtensionTopic(@ControlCenterModule.StreamsAppId String streamsAppId, OrderedKeyPrefixedSerdeSupplier<Controlcenter.ClusterContext, Controlcenter.Cluster> keySerdeSupplier, UberSerde<Controlcenter.Cluster> clusterSerde) {
        return new TopicStoreMaster.Topic<Bytes, Controlcenter.Cluster, Void, Controlcenter.Cluster>(TopicStoreMaster.getInternalTopicName(streamsAppId, CLUSTER_STREAM_EXTENSION_TOPIC), null, (UberSerde<Bytes>)keySerdeSupplier.get(), clusterSerde, false);
    }

    @Provides
    @Inject
    @ConsumerGroupAggTpStore
    protected TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> getConsumerGroupAggrTopicPartitionStore(UberSerde<String> stringSerde, UberSerde<Controlcenter.VerifiableMonitoringMessage> verifiableMonitoringMessageUberSerde) {
        boolean rollup = false;
        return new TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long>(CONSUMER_GROUP_AGGREGATE_TP_STORE, stringSerde, verifiableMonitoringMessageUberSerde, UberSerdes.longs(), rollup);
    }

    @Provides
    @Inject
    @ConsumerGroupGroupAggStore
    protected TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> getConsumerGroupGroupAggregateStore(UberSerde<String> stringSerde, UberSerde<Controlcenter.VerifiableMonitoringMessage> verifiableMonitoringMessageUberSerde) {
        boolean rollup = true;
        return new TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long>(CONSUMER_GROUP_GROUP_AGGREGATE_STORE, stringSerde, verifiableMonitoringMessageUberSerde, UberSerdes.longs(), rollup);
    }

    @Provides
    @Inject
    @ExpectedGroupConsumptionAggregateTopic
    protected TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void> getExpectedGroupConsumptionAggregateTopic(@ControlCenterModule.StreamsAppId String streamsAppId, UberSerde<Controlcenter.WindowedClusterGroup> windowedClusterGroupSerde, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde) {
        return new TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void>(TopicStoreMaster.getInternalTopicName(streamsAppId, EXPECTED_GROUP_CONSUMPTION_AGGREGATE_TOPIC), null, windowedClusterGroupSerde, monitoringMessageSerde, false);
    }

    @Provides
    @Inject
    @ActualGroupConsumptionAggregateTopic
    protected TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void> getActualGroupConsumptionAggregateTopic(@ControlCenterModule.StreamsAppId String streamsAppId, UberSerde<Controlcenter.WindowedClusterGroup> windowedClusterGroupSerde, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde) {
        return new TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void>(TopicStoreMaster.getInternalTopicName(streamsAppId, ACTUAL_GROUP_CONSUMPTION_AGGREGATE_TOPIC), null, windowedClusterGroupSerde, monitoringMessageSerde, false);
    }

    @Provides
    @Inject
    @MetricsTriggerMeasurementTopic
    protected TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement, Void, Void> getMetricsTriggerMeasurementTopic(@ControlCenterModule.StreamsAppId String streamsAppId, UberSerde<Controlcenter.WindowedClusterGroup> windowedClusterGroupSerde, UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde) {
        return new TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement, Void, Void>(TopicStoreMaster.getInternalTopicName(streamsAppId, METRICS_TRIGGER_MEASUREMENT_TOPIC), null, windowedClusterGroupSerde, triggerMeasurementUberSerde, false);
    }

    @Provides
    @Inject
    @VerifierStore
    protected TopicStoreMaster.Store<Bytes, MonitoringVerifier, MonitoringVerifier> getVerifierStore(@SerializationModule.VerifierKeySerde OrderedKeyUberSerde<Monitoring.MonitoringMessage> keySerde, UberSerde<MonitoringVerifier> monitoringVerifierUberSerde) {
        return new TopicStoreMaster.Store<Monitoring.MonitoringMessage, MonitoringVerifier, MonitoringVerifier>(VERIFIER_STORE_NAME, (UberSerde<Monitoring.MonitoringMessage>)keySerde, monitoringVerifierUberSerde, monitoringVerifierUberSerde, false);
    }

    @Provides
    @Inject
    @MonitoringTriggerStore
    protected TopicStoreMaster.Store<Bytes, Controlcenter.TriggerMeasurement, Controlcenter.TriggerMeasurement> getMonitoringTriggerStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde) {
        return new TopicStoreMaster.Store<Bytes, Controlcenter.TriggerMeasurement, Controlcenter.TriggerMeasurement>(MONITORING_TRIGGER_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), triggerMeasurementUberSerde, triggerMeasurementUberSerde, false);
    }

    @Provides
    @Inject
    @TriggerActionsStore
    protected TopicStoreMaster.Store<Bytes, Controlcenter.TriggerActions, Controlcenter.TriggerActions> getTriggerActionsStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Controlcenter.TriggerActions> triggerActionsUberSerde) {
        return new TopicStoreMaster.Store<Bytes, Controlcenter.TriggerActions, Controlcenter.TriggerActions>(TRIGGER_ACTIONS_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), triggerActionsUberSerde, triggerActionsUberSerde, false);
    }

    @Provides
    @Inject
    @TriggerEventsStore
    protected TopicStoreMaster.Store<Bytes, Controlcenter.VerifiableTriggerInfo, Controlcenter.VerifiableTriggerInfo> getTriggerEventsStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Controlcenter.VerifiableTriggerInfo> verifiableTriggerUberSerde) {
        return new TopicStoreMaster.Store<Bytes, Controlcenter.VerifiableTriggerInfo, Controlcenter.VerifiableTriggerInfo>(TRIGGER_EVENTS_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), verifiableTriggerUberSerde, verifiableTriggerUberSerde, false);
    }

    @Provides
    @Inject
    @KstreamOuterOther103
    protected TopicStoreMaster.Store<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Controlcenter.TriggerMeasurement> getKstreamOuterOther(UberSerde<Controlcenter.WindowedClusterGroup> windowedClusterGroupSerde, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde, UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde) {
        return new TopicStoreMaster.Store<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Controlcenter.TriggerMeasurement>(KSTREAM_OUTEROTHER, windowedClusterGroupSerde, monitoringMessageSerde, triggerMeasurementUberSerde, new WindowStoreSerde<Controlcenter.WindowedClusterGroup>(windowedClusterGroupSerde), false);
    }

    @Provides
    @Inject
    @KstreamOuterThis102
    protected TopicStoreMaster.Store<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Controlcenter.TriggerMeasurement> getKstreamOuterthis(UberSerde<Controlcenter.WindowedClusterGroup> windowedClusterGroupSerde, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde, UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementUberSerde) {
        return new TopicStoreMaster.Store<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Controlcenter.TriggerMeasurement>(KSTREAM_OUTERTHIS, windowedClusterGroupSerde, monitoringMessageSerde, triggerMeasurementUberSerde, new WindowStoreSerde<Controlcenter.WindowedClusterGroup>(windowedClusterGroupSerde), false);
    }

    @Provides
    @Inject
    @AlertHistoryStore
    protected TopicStoreMaster.Store<Bytes, Alert.AlertInfo, Alert.AlertInfo> getAlertHistoryStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Alert.AlertInfo> alertInfoUberSerde) {
        return new TopicStoreMaster.Store<Bytes, Alert.AlertInfo, Alert.AlertInfo>(ALERT_HISTORY_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), alertInfoUberSerde, alertInfoUberSerde, false);
    }

    @Provides
    @Inject
    @GroupStore
    protected TopicStoreMaster.Store<Bytes, Controlcenter.WindowedGrouping, Controlcenter.WindowedGrouping> getGroupStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Controlcenter.WindowedGrouping> windowedGroupingUberSerde) {
        return new TopicStoreMaster.Store<Bytes, Controlcenter.WindowedGrouping, Controlcenter.WindowedGrouping>(GROUP_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), windowedGroupingUberSerde, windowedGroupingUberSerde, new WindowStoreSerde(keySerdeSupplier.get()), true);
    }

    @Provides
    @Inject
    @MonitoringStreamStore
    protected TopicStoreMaster.Store<Bytes, Monitoring.MonitoringMessage, Monitoring.MonitoringMessage> getMonitoringStreamStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde) {
        return new TopicStoreMaster.Store<Bytes, Monitoring.MonitoringMessage, Monitoring.MonitoringMessage>(MONITORING_STREAM_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), monitoringMessageSerde, monitoringMessageSerde, new WindowStoreSerde(keySerdeSupplier.get()), true);
    }

    @Provides
    @Inject
    @MonitoringMessageAggregatorWindowsStore
    protected TopicStoreMaster.Store<Bytes, Monitoring.MonitoringMessage, Monitoring.MonitoringMessage> getMonitoringMessageAggregatorWindowsStore(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde) {
        return new TopicStoreMaster.Store<Bytes, Monitoring.MonitoringMessage, Monitoring.MonitoringMessage>(MONITORING_AGGREGATOR_WINDOWS_STORE_NAME, (UberSerde<Bytes>)keySerdeSupplier.get(), monitoringMessageSerde, monitoringMessageSerde, new WindowStoreSerde(keySerdeSupplier.get()), true);
    }

    @Provides
    @Inject
    @MetricsAggregateStore
    protected TopicStoreMaster.Store<ByteBuffer, MetricHolder, MetricHolder> getMetricsAggregatorWindowsStore(UberSerde<ByteBuffer> byteBufferSerde, UberSerde<MetricHolder> metricValuesSerde) {
        return new TopicStoreMaster.Store<ByteBuffer, MetricHolder, MetricHolder>(METRICS_AGGREGATE_STORE, byteBufferSerde, metricValuesSerde, metricValuesSerde, new WindowStoreSerde<ByteBuffer>(byteBufferSerde), false);
    }

    @Provides
    @Inject
    @AggregatedTopicPartitionTableWindowsStore
    protected TopicStoreMaster.Store<Controlcenter.TopicPartition, Monitoring.MonitoringMessage, Controlcenter.ClientGroupProductionAggregate> getAggregatedTopicPartitionTableWindowsStore(UberSerde<Controlcenter.TopicPartition> topicPartitionSerde, UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde, UberSerde<Controlcenter.ClientGroupProductionAggregate> clientGroupProductionAggregateUberSerde) {
        return new TopicStoreMaster.Store<Controlcenter.TopicPartition, Monitoring.MonitoringMessage, Controlcenter.ClientGroupProductionAggregate>(AGG_TOPIC_PARTITION_TABLE_WINDOWS_STORE_NAME, topicPartitionSerde, monitoringMessageSerde, clientGroupProductionAggregateUberSerde, new WindowStoreSerde<Controlcenter.TopicPartition>(topicPartitionSerde), true);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface AggregatedTopicPartitionTableWindowsStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MetricsAggregateStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MonitoringMessageAggregatorWindowsStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MonitoringStreamStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface GroupStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface AlertHistoryStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KstreamOuterThis102 {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KstreamOuterOther103 {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerEventsStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerActionsStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MonitoringTriggerStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface VerifierStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MetricsTriggerMeasurementTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ActualGroupConsumptionAggregateTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ExpectedGroupConsumptionAggregateTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConsumerGroupGroupAggStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConsumerGroupAggTpStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ClusterStreamExtensionTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface GroupStreamExtensionTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MonitoringMsgExtensionStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ReKeyedTriggerEventTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ReKeyedMonitoringTopic {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MetricsAggregateRepartitionTopic {
    }
}

