/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.StreamsModule;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.aggregation.MetricEvent;
import io.confluent.controlcenter.telemetry.TelemetryModule;
import io.confluent.controlcenter.util.ClusterTopicPartition;
import io.confluent.controlcenter.util.MinMeasurableStat;
import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.monitoring.record.Monitoring;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowExtractor
implements TimestampExtractor {
    private static final Logger log = LoggerFactory.getLogger(WindowExtractor.class);
    private static final String METRIC_GROUP = "streams";
    private static String monitoringTopicName = null;
    private static String metricsTopicName = null;
    private static LoadingCache<ClusterTopicPartition, Sensor> metricsCache = null;

    @Inject
    public static void setupStreamsTelemetry(final @TelemetryModule.C3Metrics Provider<Metrics> metricsProvider, final @StreamsModule.StreamsMetricConfig MetricConfig metricConfig, TopicStoreMaster topicStoreMaster) {
        monitoringTopicName = topicStoreMaster.getMonitoringTopicName();
        metricsTopicName = topicStoreMaster.getMetricsTopicName();
        log.info("Capturing metrics for topic names {} {}", (Object)monitoringTopicName, (Object)metricsTopicName);
        metricsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ClusterTopicPartition, Sensor>(){
            private final MinMeasurableStat monitoringInputTopicGauges = new MinMeasurableStat();
            private final MinMeasurableStat metricsInputTopicGauges = new MinMeasurableStat();

            public synchronized Sensor getOrCreateSensor(String sensorName, MinMeasurableStat minSet, Sensor ... parents) {
                Map emptyTags = Collections.unmodifiableMap(new HashMap());
                Metrics metrics = (Metrics)metricsProvider.get();
                Sensor sensor = metrics.getSensor(sensorName);
                if (sensor == null) {
                    sensor = metrics.sensor(sensorName, metricConfig, parents);
                    sensor.add(new MetricName(sensor.name() + ".count", WindowExtractor.METRIC_GROUP, "WindowExtractor", emptyTags), (MeasurableStat)new WindowedCount());
                    sensor.add(new MetricName(sensor.name() + ".rate", WindowExtractor.METRIC_GROUP, "WindowExtractor", emptyTags), (MeasurableStat)new Rate((SampledStat)new WindowedCount()));
                    Max max = new Max();
                    sensor.add(new MetricName(sensor.name() + ".timestamp.max", WindowExtractor.METRIC_GROUP, "WindowExtractor", emptyTags), (MeasurableStat)max);
                    sensor.add(new MetricName(sensor.name() + ".timestamp.min", WindowExtractor.METRIC_GROUP, "WindowExtractor", emptyTags), (MeasurableStat)new Min());
                    if (minSet != null) {
                        minSet.addGauge((MeasurableStat)max);
                    }
                }
                return sensor;
            }

            public synchronized Sensor getOrCreateSensor(String sensorName, Map<String, String> tags, MeasurableStat minSet) {
                Metrics metrics = (Metrics)metricsProvider.get();
                Sensor sensor = metrics.getSensor(sensorName);
                if (sensor == null) {
                    sensor = metrics.sensor(sensorName, metricConfig, new Sensor[0]);
                    sensor.add(new MetricName(sensor.name() + ".count", WindowExtractor.METRIC_GROUP, "WindowExtractor", tags), (MeasurableStat)new WindowedCount());
                    sensor.add(new MetricName(sensor.name() + ".rate", WindowExtractor.METRIC_GROUP, "WindowExtractor", tags), (MeasurableStat)new Rate((SampledStat)new WindowedCount()));
                    sensor.add(new MetricName(sensor.name() + ".timestamp", WindowExtractor.METRIC_GROUP, "WindowExtractor", tags), (MeasurableStat)new Min());
                    sensor.add(new MetricName(sensor.name() + ".min", WindowExtractor.METRIC_GROUP, "WindowExtractor", tags), minSet);
                }
                return sensor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Sensor load(@NotNull ClusterTopicPartition key) throws Exception {
                Metrics metrics = (Metrics)metricsProvider.get();
                synchronized (metrics) {
                    Sensor[] sensorArray;
                    String topic = key.topicPartition.topic();
                    Sensor clusterSensor = null;
                    MinMeasurableStat mms = null;
                    log.debug("making sensor for key={}", (Object)key);
                    if (key.cluster != null) {
                        if (StringUtils.equals((CharSequence)monitoringTopicName, (CharSequence)topic)) {
                            mms = this.monitoringInputTopicGauges;
                            clusterSensor = this.getOrCreateSensor("monitoring-input-topic-progress-" + key.cluster, (Map<String, String>)ImmutableMap.of((Object)"input", (Object)"monitoring", (Object)"progress", (Object)"input-topic", (Object)"cluster", (Object)key.cluster), mms);
                        } else if (StringUtils.equals((CharSequence)metricsTopicName, (CharSequence)topic)) {
                            mms = this.metricsInputTopicGauges;
                            clusterSensor = this.getOrCreateSensor("metrics-input-topic-progress-" + key.cluster, (Map<String, String>)ImmutableMap.of((Object)"input", (Object)"metrics", (Object)"progress", (Object)"input-topic", (Object)"cluster", (Object)key.cluster), mms);
                        }
                    }
                    if (clusterSensor == null) {
                        sensorArray = null;
                    } else {
                        Sensor[] sensorArray2 = new Sensor[1];
                        sensorArray = sensorArray2;
                        sensorArray2[0] = clusterSensor;
                    }
                    Sensor topicSensor = this.getOrCreateSensor(topic, mms, sensorArray);
                    return this.getOrCreateSensor(key.topicPartition.toString(), mms, topicSensor);
                }
            }
        });
    }

    public long extract(ConsumerRecord<Object, Object> record, long previousTimestamp) {
        long timestamp = 0L;
        String clusterId = null;
        try {
            if (record.value() instanceof Monitoring.MonitoringMessage) {
                timestamp = ((Monitoring.MonitoringMessage)record.value()).getWindow();
                clusterId = ((Monitoring.MonitoringMessage)record.value()).getClusterId();
            } else if (record.value() instanceof Controlcenter.ClientGroup) {
                timestamp = ((Controlcenter.ClientGroup)record.value()).getWindow();
            } else if (record.value() instanceof Controlcenter.WindowedGrouping) {
                timestamp = ((Controlcenter.WindowedGrouping)record.value()).getWindow();
            } else if (record.value() instanceof Controlcenter.VerifiableMonitoringMessage) {
                Controlcenter.VerifiableMonitoringMessage value = (Controlcenter.VerifiableMonitoringMessage)record.value();
                timestamp = value.getMonitoringMessage().getWindow();
                clusterId = value.getMonitoringMessage().getClusterId();
            } else if (record.value() instanceof Controlcenter.TriggerEvent) {
                timestamp = ((Controlcenter.TriggerEvent)record.value()).getWindow();
            } else if (record.value() instanceof ConfluentMetric.MetricsMessage) {
                timestamp = ((ConfluentMetric.MetricsMessage)record.value()).getTimestamp();
                clusterId = ((ConfluentMetric.MetricsMessage)record.value()).getClusterId();
            } else if (record.key() instanceof MetricEvent) {
                timestamp = record.timestamp();
            } else if (record.key() instanceof Controlcenter.WindowedClusterGroup) {
                timestamp = ((Controlcenter.WindowedClusterGroup)record.key()).getWindow();
            } else {
                log.warn("unable to extract message timestamp: unknown message type");
            }
        }
        catch (Exception e) {
            log.warn("unable to extract message timestamp: error extracting timestamp", (Throwable)e);
        }
        ClusterTopicPartition ctp = new ClusterTopicPartition(clusterId, new TopicPartition(record.topic(), record.partition()));
        if (metricsCache != null && timestamp > 0L) {
            Sensor tpSensor = (Sensor)metricsCache.getUnchecked((Object)ctp);
            tpSensor.record((double)timestamp);
        }
        if (timestamp <= 0L) {
            if (previousTimestamp >= 0L) {
                log.debug("Extracted timestamp {} <=0, will return previousTimestamp {}", (Object)timestamp, (Object)previousTimestamp);
                return previousTimestamp;
            }
            log.debug("Extracted timestamp {} <=0 and previousTimestamp < 0, will return 0", (Object)timestamp);
            return 0L;
        }
        return timestamp;
    }
}

