/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.alert;

import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.monitoring.record.Monitoring;
import org.apache.kafka.streams.kstream.ValueJoiner;

public class MonitoringTriggerMeasurementJoiner
implements ValueJoiner<Monitoring.MonitoringMessage, Monitoring.MonitoringMessage, Controlcenter.TriggerMeasurement> {
    public Controlcenter.TriggerMeasurement apply(Monitoring.MonitoringMessage actualConsumptionValue, Monitoring.MonitoringMessage expectedConsumptionValue) {
        if (actualConsumptionValue == null) {
            return null;
        }
        if (expectedConsumptionValue == null) {
            expectedConsumptionValue = Monitoring.MonitoringMessage.newBuilder((Monitoring.MonitoringMessage)actualConsumptionValue).clearCount().clearTotalLatency().clearMaxLatency().build();
        }
        if (expectedConsumptionValue.getClientType() == Monitoring.ClientType.CONTROLCENTER && actualConsumptionValue.getClientType() == Monitoring.ClientType.CONTROLCENTER) {
            return Controlcenter.TriggerMeasurement.newBuilder().setHeartbeat(true).build();
        }
        if ((expectedConsumptionValue.getType() == Monitoring.MessageType.ERROR || actualConsumptionValue.getType() == Monitoring.MessageType.ERROR) && expectedConsumptionValue.getCount() == 0L && actualConsumptionValue.getCount() == 0L) {
            return null;
        }
        Controlcenter.ClientTriggerMeasurement.Builder clientMeasurementBuilder = Controlcenter.ClientTriggerMeasurement.newBuilder().setConsumptionDiff(expectedConsumptionValue.getCount() - actualConsumptionValue.getCount()).setMaxLatency(actualConsumptionValue.getMaxLatency()).setAvgLatency(actualConsumptionValue.getCount() > 0L ? actualConsumptionValue.getTotalLatency() / actualConsumptionValue.getCount() : 0L).setHasError(expectedConsumptionValue.getType() == Monitoring.MessageType.ERROR || actualConsumptionValue.getType() == Monitoring.MessageType.ERROR);
        return Controlcenter.TriggerMeasurement.newBuilder().setClusterId(expectedConsumptionValue.getClusterId()).setComponent(expectedConsumptionValue.getGroup()).setComponentType(Controlcenter.ComponentType.CONSUMER_GROUP).setWindow(-1L).setClientMeasurement(clientMeasurementBuilder).setHeartbeat(false).setArrivalTime(Math.max(expectedConsumptionValue.getArrivalTime(), actualConsumptionValue.getArrivalTime())).build();
    }
}

