/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.group;

import io.confluent.controlcenter.keys.Keys;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.TypeMapper;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.OrderedKeyPrefixedSerde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowedGroupingTypeMapper
implements TypeMapper<Void, Controlcenter.WindowedGrouping> {
    private static final Logger log = LoggerFactory.getLogger(WindowedGroupingTypeMapper.class);
    private final OrderedKeyPrefixedSerde<Keys.KeyType, Monitoring.MonitoringMessage> serde;

    public WindowedGroupingTypeMapper(OrderedKeyPrefixedSerde<Keys.KeyType, Monitoring.MonitoringMessage> serde) {
        this.serde = serde;
    }

    private Controlcenter.MemberInfo selectMember(Monitoring.MonitoringMessage value) {
        Controlcenter.MemberInfo.Builder mib = Controlcenter.MemberInfo.newBuilder();
        switch ((Keys.KeyType)this.serde.prefix()) {
            case INFO_CLIENTIDS_IN_GROUP: {
                mib.setClientId(value.getClientId());
                break;
            }
            case INFO_GROUPS_IN_CLIENTTYPE: {
                mib.setGroup(value.getGroup());
                break;
            }
            case INFO_TOPICS_IN_CLIENTTYPE: {
                mib.setTopic(value.getTopic());
                break;
            }
            case INFO_TOPICPARTITIONS_IN_CLIENT: 
            case INFO_TOPICPARTITIONS_IN_GROUP: {
                mib.setTopicPartition(Controlcenter.TopicPartition.newBuilder().setTopic(value.getTopic()).setPartition(value.getPartition()).build());
                break;
            }
            default: {
                log.error("invalid type={}", (Object)this.serde.prefix());
            }
        }
        return mib.build();
    }

    public KeyValue<Bytes, Controlcenter.WindowedGrouping> apply(Void key, Monitoring.MonitoringMessage value) {
        Controlcenter.WindowedGrouping cgi = Controlcenter.WindowedGrouping.newBuilder().setWindow(value.getWindow()).addMembers(this.selectMember(value)).build();
        return KeyValue.pair((Object)this.serde.key((Object)value), (Object)cgi);
    }
}

