/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.internals;

import io.confluent.controlcenter.streams.internals.KeyValueIteratorFacade;
import java.time.Instant;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class ReadOnlyWindowStoreFacade<K, V>
implements ReadOnlyWindowStore<K, V> {
    public final TimestampedWindowStore<K, V> inner;

    public ReadOnlyWindowStoreFacade(TimestampedWindowStore<K, V> store) {
        this.inner = store;
    }

    public V fetch(K key, long time) {
        ValueAndTimestamp valueAndTimestamp = (ValueAndTimestamp)this.inner.fetch(key, time);
        return (V)(valueAndTimestamp == null ? null : valueAndTimestamp.value());
    }

    public WindowStoreIterator<V> fetch(K key, Instant from, Instant to) throws IllegalArgumentException {
        return new WindowStoreIteratorFacade(this.inner.fetch(key, from, to));
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to, Instant fromTime, Instant toTime) throws IllegalArgumentException {
        return new KeyValueIteratorFacade(this.inner.fetch(from, to, fromTime, toTime));
    }

    public KeyValueIterator<Windowed<K>, V> fetchAll(Instant from, Instant to) throws IllegalArgumentException {
        KeyValueIterator innerIterator = this.inner.fetchAll(from, to);
        return new KeyValueIteratorFacade(innerIterator);
    }

    public WindowStoreIterator<V> backwardFetch(K k, Instant instant, Instant instant1) throws IllegalArgumentException {
        WindowStoreIterator innerIterator = this.inner.backwardFetch(k, instant, instant1);
        return new WindowStoreIteratorFacade(innerIterator);
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetch(K k, K k1, Instant instant, Instant instant1) throws IllegalArgumentException {
        KeyValueIterator innerIterator = this.inner.backwardFetch(k, k1, instant, instant1);
        return new KeyValueIteratorFacade(innerIterator);
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(Instant instant, Instant instant1) throws IllegalArgumentException {
        KeyValueIterator innerIterator = this.inner.backwardFetchAll(instant, instant1);
        return new KeyValueIteratorFacade(innerIterator);
    }

    public KeyValueIterator<Windowed<K>, V> all() {
        KeyValueIterator innerIterator = this.inner.all();
        return new KeyValueIteratorFacade(innerIterator);
    }

    private static class WindowStoreIteratorFacade<V>
    implements WindowStoreIterator<V> {
        final KeyValueIterator<Long, ValueAndTimestamp<V>> innerIterator;

        WindowStoreIteratorFacade(KeyValueIterator<Long, ValueAndTimestamp<V>> iterator) {
            this.innerIterator = iterator;
        }

        public void close() {
            this.innerIterator.close();
        }

        public Long peekNextKey() {
            return (Long)this.innerIterator.peekNextKey();
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public KeyValue<Long, V> next() {
            KeyValue innerKeyValue = (KeyValue)this.innerIterator.next();
            return KeyValue.pair((Object)innerKeyValue.key, (Object)((ValueAndTimestamp)innerKeyValue.value).value());
        }
    }
}

