/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.monitoring;

import io.confluent.controlcenter.streams.UntypedPredicates;
import io.confluent.monitoring.record.Monitoring;
import org.apache.kafka.streams.kstream.Predicate;

public class MonitoringPredicates {
    private static final MonitoringMessageType IS_ERROR = new MonitoringMessageType(Monitoring.MessageType.ERROR);
    private static final MonitoringMessageType IS_NORMAL = new MonitoringMessageType(Monitoring.MessageType.NORMAL);
    private static final MonitoringMessageType IS_HEARTBEAT = new MonitoringMessageType(Monitoring.MessageType.HEARTBEAT);
    private static final UntypedPredicates.UntypedKeyPredicate<Monitoring.MonitoringMessage> HAS_WINDOW = new UntypedPredicates.UntypedKeyPredicate<Monitoring.MonitoringMessage>(){

        public boolean test(Object key, Monitoring.MonitoringMessage value) {
            return value.getWindow() >= 0L;
        }
    };

    public static <K> Predicate<K, Monitoring.MonitoringMessage> isError() {
        return IS_ERROR.withNarrowedType();
    }

    public static <K> Predicate<K, Monitoring.MonitoringMessage> isNormal() {
        return IS_NORMAL.withNarrowedType();
    }

    public static <K> Predicate<K, Monitoring.MonitoringMessage> isHeartbeat() {
        return IS_HEARTBEAT.withNarrowedType();
    }

    public static <K> Predicate<K, Monitoring.MonitoringMessage> hasWindow() {
        return HAS_WINDOW.withNarrowedType();
    }

    private static class MonitoringMessageType
    extends UntypedPredicates.UntypedKeyPredicate<Monitoring.MonitoringMessage> {
        private final Monitoring.MessageType type;

        MonitoringMessageType(Monitoring.MessageType type) {
            this.type = type;
        }

        public boolean test(Object k, Monitoring.MonitoringMessage value) {
            return this.type.equals((Object)value.getType());
        }
    }
}

