/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.verify;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rollup.Rollup;
import io.confluent.controlcenter.streams.C3Stream;
import io.confluent.controlcenter.streams.Predicates;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.verify.ThroughTopicVerifierTransformerSupplier;
import io.confluent.monitoring.common.Clock;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.UberSerde;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;

public class Verifiable {
    private Clock clock;

    @Inject
    public Verifiable(Clock clock) {
        this.clock = clock;
    }

    public <K> C3Stream<K, Monitoring.MonitoringMessage> transform(C3Stream<K, Monitoring.MonitoringMessage> inputStream, UberSerde<K> keySerde, TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> store) {
        assert (!store.rollup);
        return this.transformImpl(inputStream, keySerde, store, null);
    }

    public <K> C3Stream<K, Monitoring.MonitoringMessage> transform(C3Stream<K, Monitoring.MonitoringMessage> inputStream, UberSerde<K> keySerde, TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> store, Rollup rollup) {
        assert (store.rollup);
        return this.transformImpl(inputStream, keySerde, store, rollup);
    }

    protected <K> C3Stream<K, Monitoring.MonitoringMessage> transformImpl(C3Stream<K, Monitoring.MonitoringMessage> inputStream, final UberSerde<K> keySerde, TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> store, final Rollup rollup) {
        TopicStoreMaster.Store<String, Controlcenter.VerifiableMonitoringMessage, Long> rollupStore = rollup == null ? store : TopicStoreMaster.storeForRollup(store, rollup);
        return inputStream.mapValues(new ValueMapperWithKey<K, Monitoring.MonitoringMessage, Controlcenter.VerifiableMonitoringMessage>(){

            public Controlcenter.VerifiableMonitoringMessage apply(K key, Monitoring.MonitoringMessage value) {
                String hash = Verifiable.this.getHash(keySerde, key, value, rollup).toString();
                return Controlcenter.VerifiableMonitoringMessage.newBuilder().setMonitoringMessage(value).setGuid(hash).build();
            }
        }).transformValues(new ThroughTopicVerifierTransformerSupplier(rollupStore.name, this.clock), new String[]{rollupStore.name}).filter(Predicates.valueNotNull());
    }

    protected <K> HashCode getHash(UberSerde<K> keySerde, K key, Monitoring.MonitoringMessage value, Rollup rollup) {
        Hasher hasher = Hashing.murmur3_128().newHasher().putBytes(value.toByteArray()).putBytes(keySerde.serialize(key));
        if (rollup != null) {
            hasher.putString((CharSequence)rollup.getName(), StandardCharsets.UTF_8);
        }
        return hasher.hash();
    }
}

