/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.telemetry;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.rest.ControlCenterApplication;
import io.confluent.controlcenter.util.StreamProgressReporter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(TelemetryModule.class);

    @Inject
    @Provides
    @Singleton
    @C3Metrics
    protected Metrics provideC3Metrics(StreamProgressReporter streamProgressReporter, ControlCenterApplication controlCenterApplication) {
        Metrics metrics = controlCenterApplication.getMetrics();
        metrics.addReporter((MetricsReporter)streamProgressReporter);
        return metrics;
    }

    @Inject
    @Provides
    @C3MetricTags
    protected Map<String, String> provideC3MetricTags(Provider<ControlCenterApplication> controlCenterApplication) {
        return ((ControlCenterApplication)controlCenterApplication.get()).getMetricsTags();
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface C3MetricTags {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface C3Metrics {
    }
}

