/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.tools;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.controlcenter.util.ConfigUtils;
import io.confluent.controlcenter.util.InjectorFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.tools.StreamsResetter;

public class Resetter {
    protected final ControlCenterConfig config;
    protected final BootstrapClientConfigSupplier bootstrapClientConfigSupplier;
    protected final TopicStoreMaster topicStoreMaster;
    protected final String streamsAppId;
    protected final StreamsResetter streamsResetter;
    protected KafkaHelper kafkaHelper;
    private String adminConfigFile = null;
    protected final String configFileControlCenterId;
    protected final String configFileApplicationId;
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String BANNER = "\u001b[32m================================================================================\u001b[0m";

    @Inject
    public Resetter(ControlCenterConfig config, BootstrapClientConfigSupplier bootstrapClientConfigSupplier, TopicStoreMaster topicStoreMaster, @ControlCenterModule.StreamsAppId String streamsAppId, StreamsResetter streamsResetter, BootstrapClientSupplier bootstrapClientSupplier) {
        this.config = config;
        this.bootstrapClientConfigSupplier = bootstrapClientConfigSupplier;
        this.streamsAppId = streamsAppId;
        this.topicStoreMaster = topicStoreMaster;
        this.streamsResetter = streamsResetter;
        this.kafkaHelper = new KafkaHelper(bootstrapClientSupplier.get());
        this.configFileControlCenterId = config.getString("confluent.controlcenter.id");
        this.configFileApplicationId = Joiner.on((String)"-").join((Object)config.getString("confluent.controlcenter.name"), (Object)ControlCenterConfig.CONTROL_CENTER_VERSION, new Object[]{this.configFileControlCenterId});
    }

    public int run(Method method, boolean dryRun) {
        switch (method) {
            case RESET: {
                return this.reset(dryRun);
            }
            case CLEANUP: {
                return this.cleanup();
            }
        }
        return 1;
    }

    private int reset(boolean dryRun) {
        int result = this.doRun(this.config.getList("bootstrap.servers"), this.streamsAppId, (Set<String>)this.topicStoreMaster.getInputTopicNames(), (Set<String>)this.topicStoreMaster.getIntermediateTopicNames(), this.config.getString("confluent.controlcenter.id"), dryRun);
        if (dryRun) {
            System.out.println("\u001b[32mDone with dry-run. No topic or local data deleted.\u001b[0m");
        }
        return result;
    }

    int cleanup() {
        List<ImmutablePair<String, String>> instances;
        try {
            instances = this.kafkaHelper.getApplicationIds();
        }
        catch (Exception ex) {
            System.err.println("ERROR: Failed to extract old control-center application ids");
            ex.printStackTrace();
            return 1;
        }
        boolean deleteLater = this.deleteLater(instances);
        System.out.println(BANNER);
        boolean found = instances.removeIf(instance -> ((String)instance.getRight()).equals(this.configFileControlCenterId) && ((String)instance.getLeft()).equals(this.configFileApplicationId));
        if (found) {
            System.out.println("\u001b[31mThe cleanup script found the following instance: \n" + this.configFileApplicationId + "\nWe believe this COULD be the instance defined in your config file so it will not be prompted for cleanup.\n" + ANSI_RESET);
        }
        int noError = 0;
        if (instances.size() == 0) {
            System.out.println("\u001b[32mThe cleanup script found no instances for cleanup.\u001b[0m");
        } else {
            try (Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());){
                System.out.println("\u001b[32mHere are the instances discovered for cleanup: \u001b[0m");
                for (ImmutablePair<String, String> instance2 : instances) {
                    System.out.println(ANSI_BLUE + (String)instance2.getLeft() + ANSI_RESET);
                }
                System.out.print("\u001b[32mCleanup ALL of the instances above? [y/N]: \u001b[0m");
                boolean cont = true;
                block20: while (cont) {
                    switch (scanner.nextLine()) {
                        case "y": {
                            noError = this.cleanupAllInstances(instances);
                            cont = false;
                            continue block20;
                        }
                        case "N": {
                            System.out.println();
                            noError = this.cleanupPerInstance(scanner, instances);
                            cont = false;
                            continue block20;
                        }
                    }
                    System.out.print("\u001b[32mInvalid input. Try again. [y/N]: \u001b[0m");
                }
            }
        }
        System.out.println(BANNER);
        if (deleteLater) {
            this.deleteLocalData(this.configFileControlCenterId, this.configFileApplicationId, false);
        }
        return noError;
    }

    boolean deleteLater(List<ImmutablePair<String, String>> instances) {
        Path path = Paths.get(this.config.getString("confluent.controlcenter.data.dir"), this.configFileControlCenterId, "cp-command", this.configFileApplicationId + "-command");
        try {
            return instances.stream().noneMatch(i -> ((String)i.getRight()).equals(this.configFileControlCenterId)) && !Files.exists(path, new LinkOption[0]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    int cleanupAllInstances(List<ImmutablePair<String, String>> instances) {
        int result = 0;
        for (ImmutablePair<String, String> instance : instances) {
            String applicationId = (String)instance.getLeft();
            String controlcenterId = (String)instance.getRight();
            result += this.doRun(this.config.getList("bootstrap.servers"), applicationId, (Set<String>)this.topicStoreMaster.getInputTopicNames(), this.getIntermediateTopicNames(applicationId), controlcenterId, false);
        }
        return result == 0 ? 0 : 1;
    }

    private int cleanupPerInstance(Scanner scanner, List<ImmutablePair<String, String>> instances) {
        int result = 0;
        for (ImmutablePair<String, String> instance : instances) {
            String applicationId = (String)instance.getLeft();
            String controlcenterId = (String)instance.getRight();
            System.out.print("\u001b[32mDo you want to cleanup \u001b[34m" + applicationId + ANSI_GREEN + " ? [y/N/dryRun]: " + ANSI_RESET);
            boolean cont = true;
            block11: while (cont) {
                switch (scanner.nextLine()) {
                    case "y": {
                        result += this.doRun(this.config.getList("bootstrap.servers"), applicationId, (Set<String>)this.topicStoreMaster.getInputTopicNames(), this.getIntermediateTopicNames(applicationId), controlcenterId, false);
                        cont = false;
                        continue block11;
                    }
                    case "N": {
                        cont = false;
                        continue block11;
                    }
                    case "dryRun": {
                        this.doRun(this.config.getList("bootstrap.servers"), applicationId, (Set<String>)this.topicStoreMaster.getInputTopicNames(), this.getIntermediateTopicNames(applicationId), controlcenterId, true);
                        System.out.print("\u001b[32mFinished dryRun for \u001b[34m" + applicationId + ANSI_GREEN + " . Do you want to clean it up? [y/N/dryRun]: " + ANSI_RESET);
                        continue block11;
                    }
                }
                System.out.print("\u001b[32mInvalid input. Try again. [y/N/dryRun]: \u001b[0m");
            }
        }
        return result == 0 ? 0 : 1;
    }

    int doRun(List<String> bootstrapServers, String applicationId, Set<String> inputTopicNames, Set<String> intermediateTopicNames, String controlcenterId, boolean dryRun) {
        int exit;
        if (this.adminConfigFile == null) {
            this.adminConfigFile = this.createAdminConfigFile();
            if (this.adminConfigFile == null) {
                return 1;
            }
        }
        Joiner joiner = Joiner.on((String)",");
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("--bootstrap-servers");
        argsList.add(joiner.join(bootstrapServers));
        argsList.add("--application-id");
        argsList.add(applicationId);
        argsList.add("--config-file");
        argsList.add(this.adminConfigFile);
        argsList.add("--input-topics");
        argsList.add(joiner.join(inputTopicNames));
        argsList.add("--intermediate-topics");
        argsList.add(joiner.join(intermediateTopicNames));
        if (dryRun) {
            argsList.add("--dry-run");
        }
        if ((exit = this.streamsResetter.execute(argsList.toArray(new String[0]))) != 0) {
            System.err.println("Something went wrong in StreamsResetter");
            return 1;
        }
        this.deleteIntermediateTopics(intermediateTopicNames, applicationId, dryRun);
        this.deleteLocalData(controlcenterId, applicationId, dryRun);
        return 0;
    }

    private String createAdminConfigFile() {
        try {
            File adminConfigFile = File.createTempFile("adminConfig-", null);
            adminConfigFile.deleteOnExit();
            ConfigUtils.writePropsToFile(adminConfigFile.getAbsolutePath(), (Map<String, Object>)this.bootstrapClientConfigSupplier.get(), "Resetter");
            return adminConfigFile.getAbsolutePath();
        }
        catch (Exception ex) {
            System.err.println("ERROR: Failed to create AdminClient config file");
            ex.printStackTrace();
            return null;
        }
    }

    private Set<String> getIntermediateTopicNames(String applicationId) {
        return TopicStoreModule.INTERMEDIATE_TOPICS_SUFFIX.stream().map(suffix -> applicationId + "-" + suffix).collect(Collectors.toSet());
    }

    void deleteIntermediateTopics(Set<String> intermediateTopicNames, String applicationId, boolean dryRun) {
        System.out.println("Deleting intermediate topics (for consumer group " + applicationId + ")");
        for (String topic : intermediateTopicNames) {
            System.out.println("Deleting topic " + topic);
            if (dryRun) continue;
            this.doDeleteIntermediateTopics(topic);
        }
        System.out.println("Done.");
    }

    private void doDeleteIntermediateTopics(String topic) {
        try {
            this.kafkaHelper.deleteTopic(topic);
        }
        catch (UnknownTopicOrPartitionException e) {
            System.err.println("ERROR: Failed to delete non-existent topic " + topic);
        }
        catch (Throwable e) {
            System.err.println("ERROR: Failed to delete topic " + topic);
            e.printStackTrace();
        }
    }

    void deleteLocalData(String controlcenterId, String applicationId, boolean dryRun) {
        try {
            Path idDir = Paths.get(this.config.getString("confluent.controlcenter.data.dir"), controlcenterId);
            System.out.println("Deleting local RocksDB data in " + idDir.toAbsolutePath());
            this.doDeleteLocalData(idDir.resolve(Paths.get("cp-command", applicationId + "-command")), false, dryRun);
            this.doDeleteLocalData(idDir.resolve(Paths.get("kafka-streams", applicationId)), false, dryRun);
            this.doDeleteLocalData(idDir.resolve("cp-command"), true, dryRun);
            this.doDeleteLocalData(idDir.resolve("kafka-streams"), true, dryRun);
            this.doDeleteLocalData(idDir, true, dryRun);
        }
        catch (Exception e) {
            System.err.println("ERROR: Failed to delete local RocksDB data");
            e.printStackTrace();
        }
        System.out.println("Done.");
    }

    void doDeleteLocalData(Path path, boolean deleteIfEmpty, boolean dryRun) throws IOException {
        if (!(!Files.exists(path, new LinkOption[0]) || deleteIfEmpty && Files.list(path).findAny().isPresent())) {
            System.out.println("Deleting " + path.toAbsolutePath());
            if (!dryRun) {
                Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    public static void main(String[] args) {
        CommandLine cmd;
        if (args.length == 0) {
            System.err.println("You must provide a path to the config file");
            System.exit(1);
        }
        Options options = new Options().addOption(Option.builder().longOpt("dryRun").desc("perform dryRun on reset script (if used on cleanup script, no impact made)").build()).addOption(Option.builder().longOpt("cleanup").desc("run cleanup script; if no flag specified, default run reset script").build());
        try {
            cmd = new DefaultParser().parse(options, args);
        }
        catch (ParseException e) {
            return;
        }
        ControlCenterConfig config = new ControlCenterConfig(args[0]);
        Resetter resetter = (Resetter)InjectorFactory.createInjectorForScripts(config).getInstance(Resetter.class);
        Method method = cmd.hasOption("cleanup") ? Method.CLEANUP : Method.RESET;
        boolean dryRun = cmd.hasOption("dryRun");
        System.exit(resetter.run(method, dryRun));
    }

    static enum Method {
        RESET,
        CLEANUP;

    }
}

