/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.collect.ImmutableCollection;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reflections.Reflections;

public class ReflectionsUtils {
    public static <T> void getSubTypesOf(Reflections reflections, Class<T> type, ImmutableCollection.Builder<T> builder, Predicate<Class<?>> predicate, Function<Class<? extends T>, T> function) {
        reflections.getSubTypesOf(type).forEach(aClass -> {
            if (predicate.test((Class<?>)aClass)) {
                builder.add(function.apply((Class)aClass));
            }
        });
    }

    public static <T> void getTypesAnnotatedWith(Reflections reflections, Class<? extends Annotation> annotation, ImmutableCollection.Builder<T> builder, Predicate<Class<?>> predicate, Function<Class<?>, T> function) {
        reflections.getTypesAnnotatedWith(annotation).forEach(aClass -> {
            if (predicate.test((Class<?>)aClass)) {
                builder.add(function.apply((Class<?>)aClass));
            }
        });
    }
}

